/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.annotation;

import java.util.List;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

public class OnMissingAmazonClientCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnMissingAmazonClient.class.getName());
        for (Object amazonClientClass : (List)attributes.get((Object)"value")) {
            if (!this.isAmazonClientMissing(context, (Class)amazonClientClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isAmazonClientMissing(ConditionContext context, Class<?> amazonClientClass) {
        String amazonClientBeanName = AmazonWebserviceClientConfigurationUtils.getBeanName((String)amazonClientClass.getName());
        return !context.getBeanFactory().containsBean(amazonClientBeanName) && !context.getRegistry().containsBeanDefinition(amazonClientBeanName);
    }
}

