/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.bind.PropertySourceUtils;
import org.springframework.cloud.aws.context.config.xml.GlobalBeanDefinitionUtils;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.cloud.aws.jdbc.datasource.TomcatJdbcDataSourceFactory;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={Registrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.rds.AmazonRDSClient"})
public class AmazonRdsDatabaseAutoConfiguration {

    public static class Registrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private static final String PREFIX = "cloud.aws.rds";
        private ConfigurableEnvironment environment;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            String amazonRdsClientBeanName = AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient((Object)this, (BeanDefinitionRegistry)registry, (String)"com.amazonaws.services.rds.AmazonRDSClient", null, null).getBeanName();
            Map<String, Map<String, String>> dbInstanceConfigurations = this.getDbInstanceConfigurations();
            for (Map.Entry<String, Map<String, String>> dbInstanceEntry : dbInstanceConfigurations.entrySet()) {
                this.registerDataSource(registry, amazonRdsClientBeanName, dbInstanceEntry.getKey(), dbInstanceEntry.getValue().get("password"), Boolean.valueOf(dbInstanceEntry.getValue().containsKey("readReplicaSupport") ? dbInstanceEntry.getValue().get("readReplicaSupport") : "false"), dbInstanceEntry.getValue().get("username"), dbInstanceEntry.getValue().get("databaseName"));
            }
        }

        private void registerDataSource(BeanDefinitionRegistry beanDefinitionRegistry, String amazonRdsClientBeanName, String dbInstanceIdentifier, String password, boolean readReplica, String userName, String databaseName) {
            BeanDefinitionBuilder datasourceBuilder = this.getBeanDefinitionBuilderForDataSource(readReplica);
            datasourceBuilder.addConstructorArgReference(amazonRdsClientBeanName);
            datasourceBuilder.addConstructorArgValue((Object)dbInstanceIdentifier);
            datasourceBuilder.addConstructorArgValue((Object)password);
            datasourceBuilder.addPropertyValue("username", (Object)userName);
            datasourceBuilder.addPropertyValue("databaseName", (Object)databaseName);
            String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)beanDefinitionRegistry);
            datasourceBuilder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
            datasourceBuilder.addPropertyValue("dataSourceFactory", (Object)BeanDefinitionBuilder.rootBeanDefinition(TomcatJdbcDataSourceFactory.class).getBeanDefinition());
            beanDefinitionRegistry.registerBeanDefinition(dbInstanceIdentifier, (BeanDefinition)datasourceBuilder.getBeanDefinition());
        }

        private BeanDefinitionBuilder getBeanDefinitionBuilderForDataSource(boolean readReplicaEnabled) {
            BeanDefinitionBuilder datasourceBuilder = readReplicaEnabled ? BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsReadReplicaAwareDataSourceFactoryBean.class) : BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsDataSourceFactoryBean.class);
            return datasourceBuilder;
        }

        public void setEnvironment(Environment environment) {
            Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"Amazon RDS auto configuration requires a configurable environment");
            this.environment = (ConfigurableEnvironment)environment;
        }

        private Map<String, Map<String, String>> getDbInstanceConfigurations() {
            Map subProperties = PropertySourceUtils.getSubProperties((PropertySources)this.environment.getPropertySources(), (String)PREFIX);
            HashMap<String, Map<String, String>> dbConfigurationMap = new HashMap<String, Map<String, String>>(subProperties.keySet().size());
            for (Map.Entry subProperty : subProperties.entrySet()) {
                String subPropertyName;
                String instanceName = Registrar.extractConfigurationSubPropertyGroup((String)subProperty.getKey());
                if (!dbConfigurationMap.containsKey(instanceName)) {
                    dbConfigurationMap.put(instanceName, new HashMap());
                }
                if (!StringUtils.hasText((String)(subPropertyName = Registrar.extractConfigurationSubPropertyName((String)subProperty.getKey())))) continue;
                ((Map)dbConfigurationMap.get(instanceName)).put(subPropertyName, (String)subProperty.getValue());
            }
            return dbConfigurationMap;
        }

        private static String extractConfigurationSubPropertyGroup(String propertyName) {
            if (propertyName.lastIndexOf(".") > 1) {
                return propertyName.substring(1, propertyName.lastIndexOf("."));
            }
            return propertyName.substring(1);
        }

        private static String extractConfigurationSubPropertyName(String propertyName) {
            if (!propertyName.contains(".")) {
                return propertyName;
            }
            return propertyName.substring(propertyName.lastIndexOf(".") + 1);
        }
    }
}

