/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.recent.endpoint;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.springframework.cloud.appbroker.logging.recent.endpoint.EncodingException;

class MultipartEncoder
implements Closeable {
    private final byte[] bytesCRLF = new byte[]{13, 10};
    private final byte[] bytesSEP = new byte[]{45, 45};
    private final byte[] boundary;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    public MultipartEncoder(String boundary) {
        this.boundary = boundary.getBytes();
    }

    public void append(byte[] part) {
        try {
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesSEP);
            this.out.write(this.boundary);
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesCRLF);
            this.out.write(part);
        }
        catch (IOException e) {
            throw new EncodingException(e);
        }
    }

    public byte[] terminateAndGetBytes() {
        try {
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesSEP);
            this.out.write(this.boundary);
            this.out.write(this.bytesSEP);
            this.out.write(this.bytesCRLF);
            byte[] bytes = this.out.toByteArray();
            this.out.close();
            return bytes;
        }
        catch (IOException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

