/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.recent.endpoint;

import java.util.UUID;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.appbroker.logging.recent.RecentLogsProvider;
import org.springframework.cloud.appbroker.logging.recent.endpoint.LogMessageComparator;
import org.springframework.cloud.appbroker.logging.recent.endpoint.MultipartEncoder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class RecentLogsController {
    private static final LogMessageComparator LOG_MESSAGE_COMPARATOR = new LogMessageComparator();
    private final RecentLogsProvider recentLogsProviders;

    public RecentLogsController(@Autowired(required=false) RecentLogsProvider recentLogsProviders) {
        this.recentLogsProviders = recentLogsProviders;
    }

    @RequestMapping(value={"/logs/{serviceInstanceId}/recentlogs"})
    public Mono<ResponseEntity<byte[]>> recentLogs(@PathVariable(value="serviceInstanceId") String serviceInstanceId) {
        String multipartBoundary = UUID.randomUUID().toString();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "multipart/mixed; boundary=" + multipartBoundary);
        return this.recentLogsProviders.getLogs(serviceInstanceId).collectList().doOnNext(envelopes -> envelopes.sort(LOG_MESSAGE_COMPARATOR)).map(envelopes -> {
            MultipartEncoder multipart = new MultipartEncoder(multipartBoundary);
            for (Envelope message : envelopes) {
                multipart.append(Envelope.ADAPTER.encode((Object)message));
            }
            return new ResponseEntity((Object)multipart.terminateAndGetBytes(), (MultiValueMap)headers, HttpStatus.OK);
        });
    }
}

