/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UndeployApplicationRequest {
    private final String name;
    private final Map<String, String> properties;

    protected UndeployApplicationRequest(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public static UndeployApplicationRequestBuilder builder() {
        return new UndeployApplicationRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class UndeployApplicationRequestBuilder {
        private String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        private UndeployApplicationRequestBuilder() {
        }

        public UndeployApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UndeployApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public UndeployApplicationRequest build() {
            return new UndeployApplicationRequest(this.name, this.properties);
        }
    }
}

