/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.manager;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class RestageApplicationRequest {
    private final String name;
    private final Map<String, String> properties;

    protected RestageApplicationRequest(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static RestageApplicationRequestBuilder builder() {
        return new RestageApplicationRequestBuilder();
    }

    public static final class RestageApplicationRequestBuilder {
        private String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        private RestageApplicationRequestBuilder() {
        }

        public RestageApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RestageApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public RestageApplicationRequest build() {
            return new RestageApplicationRequest(this.name, this.properties);
        }
    }
}

