/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.oauth2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class DeleteOAuth2ClientResponse {
    private final String clientId;
    private final String clientName;
    private final List<String> scopes;
    private final List<String> authorities;
    private final List<String> grantTypes;

    DeleteOAuth2ClientResponse(String clientId, String clientName, List<String> scopes, List<String> authorities, List<String> grantTypes) {
        this.clientId = clientId;
        this.clientName = clientName;
        this.scopes = scopes;
        this.authorities = authorities;
        this.grantTypes = grantTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getAuthorities() {
        return this.authorities;
    }

    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public static DeleteOAuth2ClientResponseBuilder builder() {
        return new DeleteOAuth2ClientResponseBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteOAuth2ClientResponse)) {
            return false;
        }
        DeleteOAuth2ClientResponse that = (DeleteOAuth2ClientResponse)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientName, that.clientName) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.authorities, that.authorities) && Objects.equals(this.grantTypes, that.grantTypes);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientName, this.scopes, this.authorities, this.grantTypes);
    }

    public String toString() {
        return "DeleteOAuth2ClientResponse{clientId='" + this.clientId + '\'' + ", clientName='" + this.clientName + '\'' + ", scopes=" + this.scopes + ", authorities=" + this.authorities + ", grantTypes=" + this.grantTypes + '}';
    }

    public static class DeleteOAuth2ClientResponseBuilder {
        private String clientId;
        private String clientName;
        private final List<String> scopes = new ArrayList<String>();
        private final List<String> authorities = new ArrayList<String>();
        private final List<String> grantTypes = new ArrayList<String>();

        DeleteOAuth2ClientResponseBuilder() {
        }

        public DeleteOAuth2ClientResponseBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public DeleteOAuth2ClientResponseBuilder clientName(String name) {
            this.clientName = name;
            return this;
        }

        public DeleteOAuth2ClientResponseBuilder scopes(List<String> scopes) {
            if (!CollectionUtils.isEmpty(scopes)) {
                this.scopes.addAll(scopes);
            }
            return this;
        }

        public DeleteOAuth2ClientResponseBuilder authorities(List<String> authorities) {
            if (!CollectionUtils.isEmpty(authorities)) {
                this.authorities.addAll(authorities);
            }
            return this;
        }

        public DeleteOAuth2ClientResponseBuilder grantTypes(List<String> grantTypes) {
            if (!CollectionUtils.isEmpty(grantTypes)) {
                this.grantTypes.addAll(grantTypes);
            }
            return this;
        }

        public DeleteOAuth2ClientResponse build() {
            return new DeleteOAuth2ClientResponse(this.clientId, this.clientName, this.scopes, this.authorities, this.grantTypes);
        }
    }
}

