/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DeleteServiceInstanceRequest {
    private final String serviceInstanceName;
    private final Map<String, String> properties;

    DeleteServiceInstanceRequest(String serviceInstanceName, Map<String, String> properties) {
        this.serviceInstanceName = serviceInstanceName;
        this.properties = properties;
    }

    public static DeleteServiceInstanceRequestBuilder builder() {
        return new DeleteServiceInstanceRequestBuilder();
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class DeleteServiceInstanceRequestBuilder {
        private String serviceInstanceName;
        private final Map<String, String> properties = new HashMap<String, String>();

        DeleteServiceInstanceRequestBuilder() {
        }

        public DeleteServiceInstanceRequestBuilder serviceInstanceName(String name) {
            this.serviceInstanceName = name;
            return this;
        }

        public DeleteServiceInstanceRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public DeleteServiceInstanceRequest build() {
            return new DeleteServiceInstanceRequest(this.serviceInstanceName, this.properties);
        }
    }
}

