/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOperationsUtils;
import org.springframework.cloud.appbroker.deployer.manager.AppManager;
import org.springframework.cloud.appbroker.deployer.manager.RestageApplicationRequest;
import org.springframework.cloud.appbroker.deployer.manager.RestartApplicationRequest;
import org.springframework.cloud.appbroker.deployer.manager.StartApplicationRequest;
import reactor.core.publisher.Mono;

public class CloudFoundryAppManager
implements AppManager {
    private static final Logger LOG = LoggerFactory.getLogger(CloudFoundryAppManager.class);
    private static final String REQUEST_LOG_TEMPLATE = "request={}";
    private final CloudFoundryOperationsUtils operationsUtils;

    public CloudFoundryAppManager(CloudFoundryOperationsUtils operationsUtils) {
        this.operationsUtils = operationsUtils;
    }

    public Mono<Void> start(StartApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().start(org.cloudfoundry.operations.applications.StartApplicationRequest.builder().name(appName).build()).doOnRequest(l -> {
            LOG.info("Starting application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(v -> {
            LOG.info("Success starting application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnError(e -> {
            LOG.error(String.format("Error starting application. appName=%s, error=%s", appName, e.getMessage()), e);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }))));
    }

    public Mono<Void> stop(org.springframework.cloud.appbroker.deployer.manager.StopApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().stop(StopApplicationRequest.builder().name(appName).build()).doOnRequest(l -> {
            LOG.info("Stopping application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(v -> {
            LOG.info("Success stopping application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnError(e -> {
            LOG.error(String.format("Error stopping application. appName=%s, error=%s", appName, e.getMessage()), e);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }))));
    }

    public Mono<Void> restart(RestartApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().restart(org.cloudfoundry.operations.applications.RestartApplicationRequest.builder().name(appName).build()).doOnRequest(l -> {
            LOG.info("Restarting application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(v -> {
            LOG.info("Success restarting application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnError(e -> {
            LOG.error(String.format("Error restarting application. appName=%s, error=%s", appName, e.getMessage()), e);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }))));
    }

    public Mono<Void> restage(RestageApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().restage(org.cloudfoundry.operations.applications.RestageApplicationRequest.builder().name(appName).build()).doOnRequest(l -> {
            LOG.info("Restaging application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(v -> {
            LOG.info("Success restaging application. appName={}", appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnError(e -> {
            LOG.error(String.format("Error restaging application. appName=%s, error=%s", appName, e.getMessage()), e);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }))));
    }
}

