/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.kafka;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.NotRunning;
import kafka.utils.CoreUtils;
import kafka.utils.TestUtils;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;
import scala.Option;
import scala.collection.Seq;

@SpringBootApplication
public class KafkaApplication {
    private static final Log log = LogFactory.getLog(KafkaApplication.class);

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{KafkaApplication.class}).run(args);
    }

    static class EmbeddedZookeeper {
        private File snapshotDir = TestUtils.tempDir();
        private File logDir = TestUtils.tempDir();
        private int tickTime = 500;
        private NIOServerCnxnFactory factory = new NIOServerCnxnFactory();
        private ZooKeeperServer zookeeper;
        private InetSocketAddress addr;
        private int port;

        public EmbeddedZookeeper(int port) throws Exception {
            this.port = port;
            this.zookeeper = new ZooKeeperServer(this.snapshotDir, this.logDir, this.tickTime);
            this.addr = new InetSocketAddress("127.0.0.1", port);
            this.factory.configure(this.addr, 0);
            this.factory.startup(this.zookeeper);
        }

        public int getPort() {
            return this.port;
        }

        void shutdown() throws Exception {
            this.zookeeper.shutdown();
            this.factory.shutdown();
            Utils.delete((File)this.logDir);
            Utils.delete((File)this.snapshotDir);
        }
    }

    @Service
    static class KafkaDevServer
    implements SmartLifecycle {
        private AtomicBoolean running = new AtomicBoolean(false);
        private ZkClient zkClient;
        private EmbeddedZookeeper zookeeper;
        private KafkaServer kafkaServer;
        @Value(value="${kafka.port:${KAFKA_PORT:9092}}")
        private int port;
        @Value(value="${zk.port:${ZK_PORT:2181}}")
        private int zkPort;

        KafkaDevServer() {
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(Runnable callback) {
            this.stop();
            callback.run();
        }

        public void start() {
            if (this.running.compareAndSet(false, true)) {
                try {
                    log.info((Object)"Starting Zookeeper");
                    this.zookeeper = new EmbeddedZookeeper(this.zkPort);
                    String zkConnectString = "127.0.0.1:" + this.zookeeper.getPort();
                    log.info((Object)("Started Zookeeper at " + zkConnectString));
                    try {
                        int zkConnectionTimeout = 10000;
                        int zkSessionTimeout = 10000;
                        this.zkClient = new ZkClient(zkConnectString, zkSessionTimeout, zkConnectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
                    }
                    catch (Exception e) {
                        this.zookeeper.shutdown();
                        throw e;
                    }
                    try {
                        log.info((Object)"Creating Kafka server");
                        int nodeId = 0;
                        boolean enableControlledShutdown = true;
                        Properties brokerConfigProperties = TestUtils.createBrokerConfig((int)nodeId, (String)zkConnectString, (boolean)enableControlledShutdown, (boolean)true, (int)this.port, (Option)Option.apply(null), (Option)Option.apply(null), (Option)Option.apply(null), (boolean)true, (boolean)false, (int)0, (boolean)false, (int)0, (boolean)false, (int)0, (Option)Option.apply(null), (int)1, (boolean)false);
                        brokerConfigProperties.setProperty("replica.socket.timeout.ms", "1000");
                        brokerConfigProperties.setProperty("controller.socket.timeout.ms", "1000");
                        brokerConfigProperties.setProperty("offsets.topic.replication.factor", "1");
                        brokerConfigProperties.put("zookeeper.connect", zkConnectString);
                        this.kafkaServer = TestUtils.createServer((KafkaConfig)new KafkaConfig((Map)brokerConfigProperties), (Time)Time.SYSTEM);
                        log.info((Object)("Created Kafka server at " + this.kafkaServer.config().hostName() + ":" + this.kafkaServer.config().port()));
                    }
                    catch (Exception e) {
                        this.zookeeper.shutdown();
                        this.zkClient.close();
                        throw e;
                    }
                }
                catch (Exception e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                }
            }
        }

        public void stop() {
            if (this.running.compareAndSet(true, false)) {
                log.info((Object)"Stopping Kafka");
                try {
                    if (this.kafkaServer.brokerState().currentState() != NotRunning.state()) {
                        this.kafkaServer.shutdown();
                        this.kafkaServer.awaitShutdown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    CoreUtils.delete((Seq)this.kafkaServer.config().logDirs());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.info((Object)"Stopping Zookeeper");
                try {
                    this.zkClient.close();
                }
                catch (ZkInterruptedException zkInterruptedException) {
                    // empty catch block
                }
                try {
                    this.zookeeper.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean isRunning() {
            return this.running.get();
        }

        public int getPhase() {
            return 0;
        }
    }
}

