/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.h2;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.server.web.WebServlet;
import org.h2.tools.Console;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@EnableDiscoveryClient
@SpringBootApplication
@Controller
public class H2Application {
    private static final Log log = LogFactory.getLog(H2Application.class);

    public static void main(String[] args) {
        SpringApplication.run(H2Application.class, (String[])args);
    }

    @Bean
    public ServletRegistrationBean h2Console() {
        String urlMapping = "/*";
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new WebServlet(), new String[]{urlMapping});
        registration.addInitParameter("-webAllowOthers", "");
        return registration;
    }

    @Service
    static class H2Server
    implements SmartLifecycle {
        private AtomicBoolean running = new AtomicBoolean(false);
        private Console console;
        @Value(value="${spring.datasource.url:jdbc:h2:tcp://localhost:9096/./target/test}")
        private String dataSourceUrl;

        H2Server() {
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(Runnable callback) {
            this.stop();
            callback.run();
        }

        public void start() {
            if (this.running.compareAndSet(false, true)) {
                try {
                    log.info((Object)"Starting H2 Server");
                    this.console = new Console();
                    this.console.runTool(new String[]{"-tcp", "-tcpAllowOthers", "-tcpPort", this.getH2Port(this.dataSourceUrl)});
                }
                catch (Exception e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                }
            }
        }

        private String getH2Port(String url) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)url, (String)":");
            Assert.isTrue((tokens.length >= 5 ? 1 : 0) != 0, (String)"URL not properly formatted");
            return tokens[4].substring(0, tokens[4].indexOf("/"));
        }

        public void stop() {
            if (this.running.compareAndSet(true, false)) {
                log.info((Object)"Stopping H2 Server");
                this.console.shutdown();
            }
        }

        public boolean isRunning() {
            return this.running.get();
        }

        public int getPhase() {
            return 0;
        }
    }
}

