/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.logback.LogbackLoggingSystem;
import org.springframework.cloud.launcher.deployer.Deployer;
import org.springframework.cloud.launcher.deployer.DeployerConfiguration;
import org.springframework.cloud.launcher.deployer.DeployerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DeployerApplication {
    private static final Logger logger = LoggerFactory.getLogger(DeployerApplication.class);
    private static final String DEFAULT_VERSION = "2.1.0.RELEASE";
    private String[] args;

    public DeployerApplication(String ... args) {
        this.args = args;
    }

    public static void main(String[] args) {
        new DeployerApplication(args).run();
    }

    void run() {
        List<String> list = Arrays.asList(this.args);
        if (list.contains("--launcher.list=true")) {
            this.quiet();
            this.list();
        } else {
            this.launch();
        }
    }

    private void quiet() {
        try {
            LogbackLoggingSystem.get((ClassLoader)ClassUtils.getDefaultClassLoader()).setLogLevel("ROOT", LogLevel.OFF);
        }
        catch (Exception e) {
            logger.error("Unable to turn of ROOT logger for quiet()", (Throwable)e);
        }
    }

    private void list() {
        DeployerProperties properties = this.loadCloudProperties();
        if (!properties.getDeployables().isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(properties.getDeployables().keySet());
            System.out.println(StringUtils.collectionToDelimitedString(names, (String)" "));
        }
    }

    private DeployerProperties loadCloudProperties() {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{PropertyPlaceholderAutoConfiguration.class, DeployerConfiguration.class}).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(WebApplicationType.NONE).properties(new String[]{"spring.config.name=cloud", "logging.level.ROOT=OFF", "spring.cloud.launcher.list=true", "launcher.version=" + this.getVersion()}).run(this.args);){
            DeployerProperties deployerProperties = (DeployerProperties)context.getBean(DeployerProperties.class);
            return deployerProperties;
        }
    }

    String getVersion() {
        Package pkg = DeployerApplication.class.getPackage();
        return pkg != null ? (pkg.getImplementationVersion() == null ? DEFAULT_VERSION : pkg.getImplementationVersion()) : DEFAULT_VERSION;
    }

    private void launch() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{PropertyPlaceholderAutoConfiguration.class, DeployerConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.config.name=cloud", "banner.location=launcher-banner.txt", "launcher.version=" + this.getVersion()}).run(this.args);
        Deployer deployer = (Deployer)context.getBean(Deployer.class);
        deployer.deploy();
    }
}

