/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.logback.LogbackLoggingSystem;
import org.springframework.cloud.launcher.deployer.Deployer;
import org.springframework.cloud.launcher.deployer.DeployerConfiguration;
import org.springframework.cloud.launcher.deployer.DeployerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DeployerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DeployerThread.class);
    private static final String DEFAULT_VERSION = "1.2.3.RELEASE";
    private String[] args;

    public DeployerThread(ClassLoader classLoader, String ... args) {
        super("spring-cloud-launcher");
        this.args = args;
        this.setContextClassLoader(classLoader);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        List<String> list = Arrays.asList(this.args);
        if (list.contains("--launcher.list=true")) {
            this.quiet();
            this.list();
        } else {
            this.launch();
        }
    }

    private void quiet() {
        try {
            LogbackLoggingSystem.get((ClassLoader)ClassUtils.getDefaultClassLoader()).setLogLevel("ROOT", LogLevel.OFF);
        }
        catch (Exception e) {
            logger.error("Unable to turn of ROOT logger for quiet()", (Throwable)e);
        }
    }

    private void list() {
        DeployerProperties properties = this.loadCloudProperties();
        if (!properties.getDeployables().isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(properties.getDeployables().keySet());
            System.out.println(StringUtils.collectionToDelimitedString(names, (String)" "));
        }
    }

    private DeployerProperties loadCloudProperties() {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(new Object[]{PropertyPlaceholderAutoConfiguration.class, DeployerConfiguration.class}).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(false).properties(new String[]{"spring.config.name=cloud", "logging.level.ROOT=OFF", "spring.cloud.launcher.list=true", "launcher.version=" + this.getVersion()}).run(this.args);){
            DeployerProperties deployerProperties = (DeployerProperties)context.getBean(DeployerProperties.class);
            return deployerProperties;
        }
    }

    private String getVersion() {
        Package pkg = DeployerThread.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : DEFAULT_VERSION;
    }

    private void launch() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Object[]{PropertyPlaceholderAutoConfiguration.class, DeployerConfiguration.class}).web(false).properties(new String[]{"spring.config.name=cloud", "banner.location=launcher-banner.txt", "launcher.version=" + this.getVersion()}).run(this.args);
        Deployer deployer = (Deployer)context.getBean(Deployer.class);
        deployer.deploy();
    }
}

