/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.examples;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.event.OnGrantedEvent;
import org.springframework.integration.leader.event.OnRevokedEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LeaderController {
    private final String host = InetAddress.getLocalHost().getHostName();
    @Value(value="${spring.cloud.kubernetes.leader.role}")
    private String role;
    private Context context;

    @GetMapping(value={"/"})
    public String getInfo() {
        if (this.context == null) {
            return String.format("I am '%s' but I am not a leader of the '%s'", this.host, this.role);
        }
        return String.format("I am '%s' and I am the leader of the '%s'", this.host, this.role);
    }

    @PutMapping(value={"/"})
    public ResponseEntity<String> revokeLeadership() {
        if (this.context == null) {
            String message = String.format("Cannot revoke leadership because '%s' is not a leader", this.host);
            return ResponseEntity.badRequest().body((Object)message);
        }
        this.context.yield();
        String message = String.format("Leadership revoked for '%s'", this.host);
        return ResponseEntity.ok((Object)message);
    }

    @EventListener
    public void handleEvent(OnGrantedEvent event) {
        System.out.println(String.format("'%s' leadership granted", event.getRole()));
        this.context = event.getContext();
    }

    @EventListener
    public void handleEvent(OnRevokedEvent event) {
        System.out.println(String.format("'%s' leadership revoked", event.getRole()));
        this.context = null;
    }
}

