/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.tests.http2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootConfiguration
@EnableAutoConfiguration
@RestController
@LoadBalancerClients(value={@LoadBalancerClient(name="myservice", configuration={MyServiceConf.class}), @LoadBalancerClient(name="nossl", configuration={NosslServiceConf.class})})
public class Http2Application {
    private static Log log = LogFactory.getLog(Http2Application.class);

    @GetMapping(value={"hello"})
    public String hello() {
        return "Hello";
    }

    @Bean
    public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route(r -> r.path(new String[]{"/myprefix/**"}).filters(f -> f.stripPrefix(1)).uri("lb://myservice")).route(r -> r.path(new String[]{"/nossl/**"}).filters(f -> f.stripPrefix(1)).uri("lb://nossl")).route(r -> r.path(new String[]{"/neverssl/**"}).filters(f -> f.stripPrefix(1)).uri("http://neverssl.com")).route(r -> r.path(new String[]{"/httpbin/**"}).uri("https://nghttp2.org")).build();
    }

    public static void main(String[] args) {
        SpringApplication.run(Http2Application.class, (String[])args);
    }

    static class NosslServiceConf {
        NosslServiceConf() {
        }

        @Bean
        public ServiceInstanceListSupplier noSslStaticServiceInstanceListSupplier() {
            int port = Integer.parseInt(System.getProperty("nossl.port", "8080"));
            log.info((Object)("nossl.port = " + port));
            return ServiceInstanceListSuppliers.from((String)"nossl", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("nossl-1", "nossl", "localhost", port, false)});
        }
    }

    static class MyServiceConf {
        MyServiceConf() {
        }

        @Bean
        public ServiceInstanceListSupplier staticServiceInstanceListSupplier(Environment env) {
            Integer port = (Integer)env.getProperty("local.server.port", Integer.class, (Object)8443);
            log.info((Object)("local.server.port = " + port));
            return ServiceInstanceListSuppliers.from((String)"myservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("myservice-1", "myservice", "localhost", port.intValue(), true)});
        }
    }
}

