/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.jspecify.annotations.Nullable;

@Plugin(name="WhitespaceThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"wEx", "wThrowable", "wException"})
public final class WhitespaceThrowablePatternConverter
extends ThrowablePatternConverter {
    private WhitespaceThrowablePatternConverter(Configuration configuration, String @Nullable [] options) {
        super("WhitespaceThrowable", "throwable", options, configuration);
    }

    public void format(LogEvent event, StringBuilder buffer) {
        if (event.getThrown() != null) {
            buffer.append(this.options.getSeparator());
            super.format(event, buffer);
            buffer.append(this.options.getSeparator());
        }
    }

    public static WhitespaceThrowablePatternConverter newInstance(Configuration configuration, String @Nullable [] options) {
        return new WhitespaceThrowablePatternConverter(configuration, options);
    }
}

