/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.zipkin.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.zipkin.autoconfigure.ZipkinConnectionDetails;

class ZipkinDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ZipkinConnectionDetails> {
    private static final int ZIPKIN_PORT = 9411;

    ZipkinDockerComposeConnectionDetailsFactory() {
        super("openzipkin/zipkin", new String[]{"org.springframework.boot.zipkin.autoconfigure.ZipkinAutoConfiguration"});
    }

    protected ZipkinConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ZipkinDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ZipkinDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ZipkinConnectionDetails {
        private final String host;
        private final int port;

        ZipkinDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.port = source.ports().get(9411);
        }

        @Override
        public String getSpanEndpoint() {
            return "http://" + this.host + ":" + this.port + "/api/v2/spans";
        }
    }
}

