/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.zipkin.autoconfigure;

import java.net.http.HttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.zipkin.autoconfigure.PropertiesZipkinConnectionDetails;
import org.springframework.boot.zipkin.autoconfigure.ZipkinConnectionDetails;
import org.springframework.boot.zipkin.autoconfigure.ZipkinHttpClientBuilderCustomizer;
import org.springframework.boot.zipkin.autoconfigure.ZipkinHttpClientSender;
import org.springframework.boot.zipkin.autoconfigure.ZipkinProperties;
import org.springframework.context.annotation.Bean;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;
import zipkin2.reporter.HttpEndpointSuppliers;

@AutoConfiguration
@ConditionalOnClass(value={Encoding.class})
@EnableConfigurationProperties(value={ZipkinProperties.class})
public final class ZipkinAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ZipkinConnectionDetails.class})
    PropertiesZipkinConnectionDetails zipkinConnectionDetails(ZipkinProperties properties) {
        return new PropertiesZipkinConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    Encoding encoding(ZipkinProperties properties) {
        return switch (properties.getEncoding()) {
            default -> throw new IncompatibleClassChangeError();
            case ZipkinProperties.Encoding.JSON -> Encoding.JSON;
            case ZipkinProperties.Encoding.PROTO3 -> Encoding.PROTO3;
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={BytesMessageSender.class})
    @ConditionalOnClass(value={HttpClient.class})
    ZipkinHttpClientSender httpClientSender(ZipkinProperties properties, Encoding encoding, ObjectProvider<ZipkinHttpClientBuilderCustomizer> customizers, ObjectProvider<ZipkinConnectionDetails> connectionDetailsProvider, ObjectProvider<HttpEndpointSupplier.Factory> endpointSupplierFactoryProvider) {
        ZipkinConnectionDetails connectionDetails = (ZipkinConnectionDetails)connectionDetailsProvider.getIfAvailable(() -> new PropertiesZipkinConnectionDetails(properties));
        HttpEndpointSupplier.Factory endpointSupplierFactory = (HttpEndpointSupplier.Factory)endpointSupplierFactoryProvider.getIfAvailable(HttpEndpointSuppliers::constantFactory);
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(properties.getConnectTimeout());
        customizers.orderedStream().forEach(customizer -> customizer.customize(httpClientBuilder));
        return new ZipkinHttpClientSender(encoding, endpointSupplierFactory, connectionDetails.getSpanEndpoint(), httpClientBuilder.build(), properties.getReadTimeout());
    }
}

