/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.MaximumAllowableTagsMeterFilter;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationConvention;
import org.springframework.web.filter.ServerHttpObservationFilter;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration", "org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration", "org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration", "org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class, Observation.class, ObservationProperties.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={ObservationProperties.class})
public final class WebMvcObservationAutoConfiguration {
    @Bean
    @ConditionalOnMissingFilterBean
    FilterRegistrationBean<ServerHttpObservationFilter> webMvcObservationFilter(ObservationRegistry registry, ObjectProvider<ServerRequestObservationConvention> customConvention, ObservationProperties observationProperties) {
        String name = observationProperties.getHttp().getServer().getRequests().getName();
        ServerRequestObservationConvention convention = (ServerRequestObservationConvention)customConvention.getIfAvailable(() -> new DefaultServerRequestObservationConvention(name));
        ServerHttpObservationFilter filter = new ServerHttpObservationFilter(registry, convention);
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setOrder(-2147483647);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class, MetricsProperties.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    @EnableConfigurationProperties(value={MetricsProperties.class})
    static class MeterFilterConfiguration {
        MeterFilterConfiguration() {
        }

        @Bean
        @Order(value=0)
        MaximumAllowableTagsMeterFilter metricsHttpServerUriTagFilter(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
            String meterNamePrefix = observationProperties.getHttp().getServer().getRequests().getName();
            int maxUriTags = metricsProperties.getWeb().getServer().getMaxUriTags();
            return new MaximumAllowableTagsMeterFilter(meterNamePrefix, "uri", maxUriTags);
        }
    }
}

