/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure;

import java.io.File;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class JspTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    private static final String WAR_SOURCE_DIRECTORY_ENVIRONMENT_VARIABLE = "WAR_SOURCE_DIRECTORY";
    private final File warSourceDirectory;

    public JspTemplateAvailabilityProvider() {
        this(new File("."), System::getenv);
    }

    JspTemplateAvailabilityProvider(File rootDirectory, Function<String, @Nullable String> systemEnvironment) {
        this.warSourceDirectory = new File(rootDirectory, JspTemplateAvailabilityProvider.getWarSourceDirectory(systemEnvironment));
    }

    private static String getWarSourceDirectory(Function<String, @Nullable String> systemEnvironment) {
        String name = systemEnvironment.apply(WAR_SOURCE_DIRECTORY_ENVIRONMENT_VARIABLE);
        return name != null ? name : "src/main/webapp";
    }

    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"org.apache.jasper.compiler.JspConfig", (ClassLoader)classLoader)) {
            String resourceName = this.getResourceName(view, environment);
            if (resourceLoader.getResource(resourceName).exists()) {
                return true;
            }
            return new File(this.warSourceDirectory, resourceName).exists();
        }
        return false;
    }

    private String getResourceName(String view, Environment environment) {
        String prefix = environment.getProperty("spring.mvc.view.prefix", "");
        String suffix = environment.getProperty("spring.mvc.view.suffix", "");
        return prefix + view + suffix;
    }
}

