/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.test.autoconfigure;

import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.test.context.filter.annotation.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.webmvc.autoconfigure.WebMvcRegistrations;
import org.springframework.boot.webmvc.error.ErrorAttributes;
import org.springframework.boot.webmvc.test.autoconfigure.WebMvcTest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

class WebMvcTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<WebMvcTest> {
    private static final Class<?>[] NO_CONTROLLERS = new Class[0];
    private static final String[] OPTIONAL_INCLUDES = new String[]{"tools.jackson.databind.JacksonModule", "org.springframework.boot.jackson.JacksonComponent", "org.thymeleaf.dialect.IDialect", "com.fasterxml.jackson.databind.Module", "org.springframework.boot.jackson2.JsonComponent"};
    private static final Set<Class<?>> KNOWN_INCLUDES;
    private static final Set<Class<?>> KNOWN_INCLUDES_AND_CONTROLLER;
    private final Class<?>[] controllers = this.getAnnotation().getValue("controllers", Class[].class).orElse(NO_CONTROLLERS);

    WebMvcTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    protected Set<Class<?>> getKnownIncludes() {
        if (ObjectUtils.isEmpty((Object[])this.controllers)) {
            return KNOWN_INCLUDES_AND_CONTROLLER;
        }
        return KNOWN_INCLUDES;
    }

    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.controllers));
    }

    static {
        LinkedHashSet<Object> includes = new LinkedHashSet<Class>();
        includes.add(ControllerAdvice.class);
        includes.add(WebMvcConfigurer.class);
        includes.add(WebMvcRegistrations.class);
        includes.add(Filter.class);
        includes.add(FilterRegistrationBean.class);
        includes.add(DelegatingFilterProxyRegistrationBean.class);
        includes.add(HandlerMethodArgumentResolver.class);
        includes.add(HttpMessageConverter.class);
        includes.add(ErrorAttributes.class);
        includes.add(Converter.class);
        includes.add(GenericConverter.class);
        includes.add(HandlerInterceptor.class);
        for (String optionalInclude : OPTIONAL_INCLUDES) {
            try {
                includes.add(ClassUtils.forName((String)optionalInclude, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KNOWN_INCLUDES = Collections.unmodifiableSet(includes);
        includes = new LinkedHashSet(KNOWN_INCLUDES);
        includes.add(Controller.class);
        KNOWN_INCLUDES_AND_CONTROLLER = Collections.unmodifiableSet(includes);
    }
}

