/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.WebResourcesRuntimeHints;
import org.springframework.boot.autoconfigure.web.format.DateTimeFormatters;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.http.codec.autoconfigure.CodecsAutoConfiguration;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.validation.autoconfigure.ValidatorAdapter;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.webflux.autoconfigure.ProblemDetailsExceptionHandler;
import org.springframework.boot.webflux.autoconfigure.ReactiveMultipartAutoConfiguration;
import org.springframework.boot.webflux.autoconfigure.ResourceChainResourceHandlerRegistrationCustomizer;
import org.springframework.boot.webflux.autoconfigure.ResourceHandlerRegistrationCustomizer;
import org.springframework.boot.webflux.autoconfigure.WebFluxProperties;
import org.springframework.boot.webflux.autoconfigure.WebFluxRegistrations;
import org.springframework.boot.webflux.autoconfigure.WebSessionIdResolverAutoConfiguration;
import org.springframework.boot.webflux.autoconfigure.WelcomePageRouterFunctionFactory;
import org.springframework.boot.webflux.filter.OrderedHiddenHttpMethodFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.CacheControl;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.filter.reactive.HiddenHttpMethodFilter;
import org.springframework.web.reactive.accept.ApiVersionDeprecationHandler;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.reactive.config.ApiVersionConfigurer;
import org.springframework.web.reactive.config.BlockingExecutionConfigurer;
import org.springframework.web.reactive.config.DelegatingWebFluxConfiguration;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurationSupport;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.support.RouterFunctionMapping;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.reactive.result.method.annotation.ResponseEntityExceptionHandler;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import org.springframework.web.server.i18n.FixedLocaleContextResolver;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.InMemoryWebSessionStore;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={ReactiveMultipartAutoConfiguration.class, WebSessionIdResolverAutoConfiguration.class, CodecsAutoConfiguration.class}, afterName={"org.springframework.boot.validation.autoconfigure.ValidationAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={WebFluxConfigurer.class})
@ConditionalOnMissingBean(value={WebFluxConfigurationSupport.class})
@AutoConfigureOrder(value=-2147483638)
@ImportRuntimeHints(value={WebResourcesRuntimeHints.class})
public final class WebFluxAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    @ConditionalOnBooleanProperty(value={"spring.webflux.hiddenmethod.filter.enabled"})
    OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    static final class MaxIdleTimeInMemoryWebSessionStore
    extends InMemoryWebSessionStore {
        private final Duration timeout;

        private MaxIdleTimeInMemoryWebSessionStore(Duration timeout) {
            this.timeout = timeout;
        }

        public Mono<WebSession> createWebSession() {
            return super.createWebSession().doOnSuccess(this::setMaxIdleTime);
        }

        private void setMaxIdleTime(WebSession session) {
            session.setMaxIdleTime(this.timeout);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(value={"spring.webflux.problemdetails.enabled"})
    static class ProblemDetailsErrorHandlingConfiguration {
        ProblemDetailsErrorHandlingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ResponseEntityExceptionHandler.class})
        @Order(value=0)
        ProblemDetailsExceptionHandler problemDetailsExceptionHandler() {
            return new ProblemDetailsExceptionHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnEnabledResourceChain
    static class ResourceChainCustomizerConfiguration {
        ResourceChainCustomizerConfiguration() {
        }

        @Bean
        ResourceChainResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer(WebProperties webProperties) {
            return new ResourceChainResourceHandlerRegistrationCustomizer(webProperties.getResources());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={WebProperties.class, ServerProperties.class})
    static class EnableWebFluxConfiguration
    extends DelegatingWebFluxConfiguration {
        private final WebFluxProperties webFluxProperties;
        private final WebProperties webProperties;
        private final ServerProperties serverProperties;
        private final @Nullable WebFluxRegistrations webFluxRegistrations;

        EnableWebFluxConfiguration(WebFluxProperties webFluxProperties, WebProperties webProperties, ServerProperties serverProperties, ObjectProvider<WebFluxRegistrations> webFluxRegistrations) {
            this.webFluxProperties = webFluxProperties;
            this.webProperties = webProperties;
            this.serverProperties = serverProperties;
            this.webFluxRegistrations = (WebFluxRegistrations)webFluxRegistrations.getIfUnique();
        }

        @Bean
        public FormattingConversionService webFluxConversionService() {
            WebFluxProperties.Format format = this.webFluxProperties.getFormat();
            WebConversionService conversionService = new WebConversionService(new DateTimeFormatters().dateFormat(format.getDate()).timeFormat(format.getTime()).dateTimeFormat(format.getDateTime()));
            this.addFormatters((FormatterRegistry)conversionService);
            return conversionService;
        }

        @Bean
        public Validator webFluxValidator() {
            if (!ClassUtils.isPresent((String)"jakarta.validation.Validator", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()) || !ClassUtils.isPresent((String)"org.springframework.boot.validation.autoconfigure.ValidatorAdapter", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
                return super.webFluxValidator();
            }
            ApplicationContext applicationContext = this.getApplicationContext();
            Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"'applicationContext' must not be null");
            return ValidatorAdapter.get((ApplicationContext)applicationContext, (Validator)this.getValidator());
        }

        protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
            RequestMappingHandlerAdapter adapter;
            if (this.webFluxRegistrations != null && (adapter = this.webFluxRegistrations.getRequestMappingHandlerAdapter()) != null) {
                return adapter;
            }
            return super.createRequestMappingHandlerAdapter();
        }

        protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
            RequestMappingHandlerMapping mapping;
            if (this.webFluxRegistrations != null && (mapping = this.webFluxRegistrations.getRequestMappingHandlerMapping()) != null) {
                return mapping;
            }
            return super.createRequestMappingHandlerMapping();
        }

        @Bean
        @ConditionalOnMissingBean(name={"localeContextResolver"})
        public LocaleContextResolver localeContextResolver() {
            Locale locale = this.webProperties.getLocale();
            if (this.webProperties.getLocaleResolver() == WebProperties.LocaleResolver.FIXED) {
                Assert.state((locale != null ? 1 : 0) != 0, (String)"'locale' must not be null");
                return new FixedLocaleContextResolver(locale);
            }
            AcceptHeaderLocaleContextResolver localeContextResolver = new AcceptHeaderLocaleContextResolver();
            localeContextResolver.setDefaultLocale(locale);
            return localeContextResolver;
        }

        @Bean
        @ConditionalOnMissingBean(name={"webSessionManager"})
        WebSessionManager webSessionManager(ObjectProvider<WebSessionIdResolver> webSessionIdResolver) {
            DefaultWebSessionManager webSessionManager = new DefaultWebSessionManager();
            Duration timeout = this.serverProperties.getReactive().getSession().getTimeout();
            int maxSessions = this.serverProperties.getReactive().getSession().getMaxSessions();
            MaxIdleTimeInMemoryWebSessionStore sessionStore = new MaxIdleTimeInMemoryWebSessionStore(timeout);
            sessionStore.setMaxSessions(maxSessions);
            webSessionManager.setSessionStore((WebSessionStore)sessionStore);
            webSessionIdResolver.ifAvailable(arg_0 -> ((DefaultWebSessionManager)webSessionManager).setSessionIdResolver(arg_0));
            return webSessionManager;
        }

        @ConditionalOnMissingBean(name={"webFluxApiVersionStrategy"})
        public @Nullable ApiVersionStrategy webFluxApiVersionStrategy() {
            return super.webFluxApiVersionStrategy();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={WebProperties.class, WebFluxProperties.class})
    @Import(value={EnableWebFluxConfiguration.class})
    @Order(value=0)
    static class WebFluxConfig
    implements WebFluxConfigurer {
        private static final Log logger = LogFactory.getLog(WebFluxConfig.class);
        private final Environment environment;
        private final WebProperties.Resources resourceProperties;
        private final WebFluxProperties webFluxProperties;
        private final ListableBeanFactory beanFactory;
        private final ObjectProvider<HandlerMethodArgumentResolver> argumentResolvers;
        private final ObjectProvider<CodecCustomizer> codecCustomizers;
        private final ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizers;
        private final ObjectProvider<ViewResolver> viewResolvers;
        private final ObjectProvider<ApiVersionResolver> apiVersionResolvers;
        private final ObjectProvider<ApiVersionParser<?>> apiVersionParser;
        private final ObjectProvider<ApiVersionDeprecationHandler> apiVersionDeprecationHandler;

        WebFluxConfig(Environment environment, WebProperties webProperties, WebFluxProperties webFluxProperties, ListableBeanFactory beanFactory, ObjectProvider<HandlerMethodArgumentResolver> resolvers, ObjectProvider<CodecCustomizer> codecCustomizers, ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizers, ObjectProvider<ViewResolver> viewResolvers, ObjectProvider<ApiVersionResolver> apiVersionResolvers, ObjectProvider<ApiVersionParser<?>> apiVersionParser, ObjectProvider<ApiVersionDeprecationHandler> apiVersionDeprecationHandler) {
            this.environment = environment;
            this.resourceProperties = webProperties.getResources();
            this.webFluxProperties = webFluxProperties;
            this.beanFactory = beanFactory;
            this.argumentResolvers = resolvers;
            this.codecCustomizers = codecCustomizers;
            this.resourceHandlerRegistrationCustomizers = resourceHandlerRegistrationCustomizers;
            this.viewResolvers = viewResolvers;
            this.apiVersionResolvers = apiVersionResolvers;
            this.apiVersionParser = apiVersionParser;
            this.apiVersionDeprecationHandler = apiVersionDeprecationHandler;
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            Stream stream = this.argumentResolvers.orderedStream();
            ArgumentResolverConfigurer argumentResolverConfigurer = configurer;
            Objects.requireNonNull(argumentResolverConfigurer);
            ArgumentResolverConfigurer argumentResolverConfigurer2 = argumentResolverConfigurer;
            stream.forEach(xva$0 -> argumentResolverConfigurer2.addCustomResolver(new HandlerMethodArgumentResolver[]{xva$0}));
        }

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            this.codecCustomizers.orderedStream().forEach(customizer -> customizer.customize((CodecConfigurer)configurer));
        }

        public void configureBlockingExecution(BlockingExecutionConfigurer configurer) {
            Object taskExecutor;
            if (Threading.VIRTUAL.isActive(this.environment) && this.beanFactory.containsBean("applicationTaskExecutor") && (taskExecutor = this.beanFactory.getBean("applicationTaskExecutor")) instanceof AsyncTaskExecutor) {
                AsyncTaskExecutor asyncTaskExecutor = (AsyncTaskExecutor)taskExecutor;
                configurer.setExecutor(asyncTaskExecutor);
            }
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            String staticPathPattern;
            if (!this.resourceProperties.isAddMappings()) {
                logger.debug((Object)"Default resource handling disabled");
                return;
            }
            List<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizers = this.resourceHandlerRegistrationCustomizers.orderedStream().toList();
            String webjarsPathPattern = this.webFluxProperties.getWebjarsPathPattern();
            if (!registry.hasMappingForPattern(webjarsPathPattern)) {
                ResourceHandlerRegistration registration = registry.addResourceHandler(new String[]{webjarsPathPattern}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
                this.configureResourceCaching(registration);
                resourceHandlerRegistrationCustomizers.forEach(customizer -> customizer.customize(registration));
            }
            if (!registry.hasMappingForPattern(staticPathPattern = this.webFluxProperties.getStaticPathPattern())) {
                ResourceHandlerRegistration registration = registry.addResourceHandler(new String[]{staticPathPattern}).addResourceLocations(this.resourceProperties.getStaticLocations());
                this.configureResourceCaching(registration);
                resourceHandlerRegistrationCustomizers.forEach(customizer -> customizer.customize(registration));
            }
        }

        private void configureResourceCaching(ResourceHandlerRegistration registration) {
            CacheControl httpCacheControl;
            Duration cachePeriod = this.resourceProperties.getCache().getPeriod();
            WebProperties.Resources.Cache.Cachecontrol cacheControl = this.resourceProperties.getCache().getCachecontrol();
            if (cachePeriod != null && cacheControl.getMaxAge() == null) {
                cacheControl.setMaxAge(cachePeriod);
            }
            if ((httpCacheControl = cacheControl.toHttpCacheControl()) != null) {
                registration.setCacheControl(httpCacheControl);
            }
            registration.setUseLastModified(this.resourceProperties.getCache().isUseLastModified());
        }

        public void configureViewResolvers(ViewResolverRegistry registry) {
            this.viewResolvers.orderedStream().forEach(arg_0 -> ((ViewResolverRegistry)registry).viewResolver(arg_0));
        }

        public void addFormatters(FormatterRegistry registry) {
            ApplicationConversionService.addBeans((FormatterRegistry)registry, (ListableBeanFactory)this.beanFactory);
        }

        public void configureApiVersioning(ApiVersionConfigurer configurer) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            WebFluxProperties.Apiversion properties = this.webFluxProperties.getApiversion();
            map.from(properties::getRequired).to(arg_0 -> ((ApiVersionConfigurer)configurer).setVersionRequired(arg_0));
            map.from(properties::getDefaultVersion).to(arg_0 -> ((ApiVersionConfigurer)configurer).setDefaultVersion(arg_0));
            map.from(properties::getSupported).to(supported -> {
                ApiVersionConfigurer apiVersionConfigurer = configurer;
                Objects.requireNonNull(apiVersionConfigurer);
                ApiVersionConfigurer rec$ = apiVersionConfigurer;
                supported.forEach(xva$0 -> rec$.addSupportedVersions(new String[]{xva$0}));
            });
            map.from(properties::getDetectSupported).to(arg_0 -> ((ApiVersionConfigurer)configurer).detectSupportedVersions(arg_0));
            this.configureApiVersioningUse(configurer, properties.getUse());
            Stream stream = this.apiVersionResolvers.orderedStream();
            ApiVersionConfigurer apiVersionConfigurer = configurer;
            Objects.requireNonNull(apiVersionConfigurer);
            ApiVersionConfigurer apiVersionConfigurer2 = apiVersionConfigurer;
            stream.forEach(xva$0 -> apiVersionConfigurer2.useVersionResolver(new ApiVersionResolver[]{xva$0}));
            this.apiVersionParser.ifAvailable(arg_0 -> ((ApiVersionConfigurer)configurer).setVersionParser(arg_0));
            this.apiVersionDeprecationHandler.ifAvailable(arg_0 -> ((ApiVersionConfigurer)configurer).setDeprecationHandler(arg_0));
        }

        private void configureApiVersioningUse(ApiVersionConfigurer configurer, WebFluxProperties.Apiversion.Use use) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(use::getHeader).whenHasText().to(arg_0 -> ((ApiVersionConfigurer)configurer).useRequestHeader(arg_0));
            map.from(use::getQueryParameter).whenHasText().to(arg_0 -> ((ApiVersionConfigurer)configurer).useQueryParam(arg_0));
            map.from(use::getPathSegment).to(arg_0 -> ((ApiVersionConfigurer)configurer).usePathSegment(arg_0));
            use.getMediaTypeParameter().forEach((mediaType, parameterName) -> configurer.useMediaTypeParameter(mediaType, parameterName));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class WelcomePageConfiguration {
        WelcomePageConfiguration() {
        }

        @Bean
        @Nullable RouterFunctionMapping welcomePageRouterFunctionMapping(ApplicationContext applicationContext, WebFluxProperties webFluxProperties, WebProperties webProperties) {
            String[] staticLocations = webProperties.getResources().getStaticLocations();
            WelcomePageRouterFunctionFactory factory = new WelcomePageRouterFunctionFactory(new TemplateAvailabilityProviders(applicationContext), applicationContext, staticLocations, webFluxProperties.getStaticPathPattern());
            RouterFunction<ServerResponse> routerFunction = factory.createRouterFunction();
            if (routerFunction != null) {
                RouterFunctionMapping routerFunctionMapping = new RouterFunctionMapping(routerFunction);
                routerFunctionMapping.setOrder(1);
                return routerFunctionMapping;
            }
            return null;
        }
    }
}

