/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.webflux.autoconfigure.ReactiveMultipartProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.multipart.DefaultPartHttpMessageReader;
import org.springframework.http.codec.multipart.PartEventHttpMessageReader;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@AutoConfiguration
@ConditionalOnClass(value={DefaultPartHttpMessageReader.class, WebFluxConfigurer.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={ReactiveMultipartProperties.class})
public final class ReactiveMultipartAutoConfiguration {
    @Bean
    @Order(value=0)
    CodecCustomizer defaultPartHttpMessageReaderCustomizer(ReactiveMultipartProperties multipartProperties) {
        return configurer -> configurer.defaultCodecs().configureDefaultCodec(codec -> {
            if (codec instanceof DefaultPartHttpMessageReader) {
                DefaultPartHttpMessageReader defaultPartHttpMessageReader = (DefaultPartHttpMessageReader)codec;
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from(multipartProperties::getMaxInMemorySize).asInt(DataSize::toBytes).to(arg_0 -> ((DefaultPartHttpMessageReader)defaultPartHttpMessageReader).setMaxInMemorySize(arg_0));
                map.from(multipartProperties::getMaxHeadersSize).asInt(DataSize::toBytes).to(arg_0 -> ((DefaultPartHttpMessageReader)defaultPartHttpMessageReader).setMaxHeadersSize(arg_0));
                map.from(multipartProperties::getMaxDiskUsagePerPart).as(DataSize::toBytes).to(arg_0 -> ((DefaultPartHttpMessageReader)defaultPartHttpMessageReader).setMaxDiskUsagePerPart(arg_0));
                map.from(multipartProperties::getMaxParts).to(arg_0 -> ((DefaultPartHttpMessageReader)defaultPartHttpMessageReader).setMaxParts(arg_0));
                map.from(multipartProperties::getFileStorageDirectory).as(x$0 -> Paths.get(x$0, new String[0])).to(dir -> this.configureFileStorageDirectory(defaultPartHttpMessageReader, (Path)dir));
                map.from(multipartProperties::getHeadersCharset).to(arg_0 -> ((DefaultPartHttpMessageReader)defaultPartHttpMessageReader).setHeadersCharset(arg_0));
            } else if (codec instanceof PartEventHttpMessageReader) {
                PartEventHttpMessageReader partEventHttpMessageReader = (PartEventHttpMessageReader)codec;
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from(multipartProperties::getMaxInMemorySize).asInt(DataSize::toBytes).to(arg_0 -> ((PartEventHttpMessageReader)partEventHttpMessageReader).setMaxInMemorySize(arg_0));
                map.from(multipartProperties::getMaxHeadersSize).asInt(DataSize::toBytes).to(arg_0 -> ((PartEventHttpMessageReader)partEventHttpMessageReader).setMaxHeadersSize(arg_0));
                map.from(multipartProperties::getMaxDiskUsagePerPart).as(DataSize::toBytes).to(arg_0 -> ((PartEventHttpMessageReader)partEventHttpMessageReader).setMaxPartSize(arg_0));
                map.from(multipartProperties::getMaxParts).to(arg_0 -> ((PartEventHttpMessageReader)partEventHttpMessageReader).setMaxParts(arg_0));
                map.from(multipartProperties::getHeadersCharset).to(arg_0 -> ((PartEventHttpMessageReader)partEventHttpMessageReader).setHeadersCharset(arg_0));
            }
        });
    }

    private void configureFileStorageDirectory(DefaultPartHttpMessageReader defaultPartHttpMessageReader, Path fileStorageDirectory) {
        try {
            defaultPartHttpMessageReader.setFileStorageDirectory(fileStorageDirectory);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to configure multipart file storage directory", ex);
        }
    }
}

