/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.actuate.exchanges;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

class RecordableServerHttpRequest
implements RecordableHttpRequest {
    private final String method;
    private final HttpHeaders headers;
    private final URI uri;
    private final String remoteAddress;

    RecordableServerHttpRequest(ServerHttpRequest request) {
        this.method = request.getMethod().name();
        this.headers = request.getHeaders();
        this.uri = request.getURI();
        this.remoteAddress = RecordableServerHttpRequest.getRemoteAddress(request);
    }

    private static String getRemoteAddress(ServerHttpRequest request) {
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        InetAddress address = remoteAddress != null ? remoteAddress.getAddress() : null;
        return address != null ? address.toString() : null;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, List<String>> getHeaders() {
        LinkedHashMap headers = new LinkedHashMap();
        this.headers.forEach(headers::put);
        return Collections.unmodifiableMap(headers);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

