/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.autoconfigure.ApiversionProperties;
import org.springframework.boot.http.client.autoconfigure.PropertiesApiVersionInserter;
import org.springframework.boot.webclient.WebClientCustomizer;
import org.springframework.boot.webclient.autoconfigure.AbstractWebClientProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.reactive.function.client.WebClient;

public class PropertiesWebClientCustomizer
implements WebClientCustomizer {
    private final @Nullable AbstractWebClientProperties[] orderedProperties;
    private final @Nullable ApiVersionInserter apiVersionInserter;

    public PropertiesWebClientCustomizer(@Nullable ApiVersionInserter apiVersionInserter, @Nullable ApiVersionFormatter apiVersionFormatter, AbstractWebClientProperties ... orderedProperties) {
        this.orderedProperties = orderedProperties;
        this.apiVersionInserter = PropertiesApiVersionInserter.get((ApiVersionInserter)apiVersionInserter, (ApiVersionFormatter)apiVersionFormatter, Arrays.stream(orderedProperties).map(this::getApiVersion));
    }

    private @Nullable ApiversionProperties getApiVersion(@Nullable AbstractWebClientProperties properties) {
        return properties != null ? properties.getApiversion() : null;
    }

    @Override
    public void customize(WebClient.Builder builder) {
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)this.apiVersionInserter).to(arg_0 -> ((WebClient.Builder)builder).apiVersionInserter(arg_0));
        for (int i = this.orderedProperties.length - 1; i >= 0; --i) {
            AbstractWebClientProperties properties = this.orderedProperties[i];
            if (properties == null) continue;
            map.from(properties::getBaseUrl).whenHasText().to(arg_0 -> ((WebClient.Builder)builder).baseUrl(arg_0));
            map.from(properties::getDefaultHeader).as(this::putAllHeaders).to(arg_0 -> ((WebClient.Builder)builder).defaultHeaders(arg_0));
            map.from(properties::getApiversion).as(ApiversionProperties::getDefaultVersion).to(arg_0 -> ((WebClient.Builder)builder).defaultApiVersion(arg_0));
        }
    }

    private Consumer<HttpHeaders> putAllHeaders(Map<String, List<String>> defaultHeaders) {
        return httpHeaders -> httpHeaders.putAll(defaultHeaders);
    }
}

