/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.reactive.context;

import org.springframework.aot.AotDetector;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.web.server.reactive.context.AnnotationConfigReactiveWebServerApplicationContext;
import org.springframework.boot.web.server.reactive.context.ApplicationReactiveWebEnvironment;
import org.springframework.boot.web.server.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

class ReactiveWebServerApplicationContextFactory
implements ApplicationContextFactory {
    ReactiveWebServerApplicationContextFactory() {
    }

    public Class<? extends ConfigurableEnvironment> getEnvironmentType(WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.REACTIVE ? null : ApplicationReactiveWebEnvironment.class;
    }

    public ConfigurableEnvironment createEnvironment(WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.REACTIVE ? null : new ApplicationReactiveWebEnvironment();
    }

    public ConfigurableApplicationContext create(WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.REACTIVE ? null : this.createContext();
    }

    private ConfigurableApplicationContext createContext() {
        if (!AotDetector.useGeneratedArtifacts()) {
            return new AnnotationConfigReactiveWebServerApplicationContext();
        }
        return new ReactiveWebServerApplicationContext();
    }
}

