/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.test.client;

import java.util.List;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.test.client.TestRestTemplateContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class TestRestTemplateContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final boolean REST_TEMPLATE_BUILDER_PRESENT = ClassUtils.isPresent((String)"org.springframework.boot.restclient.RestTemplateBuilder", (ClassLoader)TestRestTemplateContextCustomizerFactory.class.getClassLoader());

    TestRestTemplateContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (!REST_TEMPLATE_BUILDER_PRESENT) {
            return null;
        }
        SpringBootTest springBootTest = (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
        return springBootTest != null ? new TestRestTemplateContextCustomizer() : null;
    }
}

