/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow.autoconfigure.servlet;

import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.websockets.jsr.Bootstrap;
import jakarta.servlet.ServletRequest;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.undertow.autoconfigure.UndertowServerProperties;
import org.springframework.boot.undertow.autoconfigure.UndertowWebServerConfiguration;
import org.springframework.boot.undertow.autoconfigure.servlet.UndertowServletWebServerFactoryCustomizer;
import org.springframework.boot.undertow.autoconfigure.servlet.WebSocketUndertowServletWebServerFactoryCustomizer;
import org.springframework.boot.undertow.servlet.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.undertow.servlet.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.autoconfigure.servlet.ServletWebServerConfiguration;
import org.springframework.boot.web.server.servlet.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.xnio.SslClientAuthMode;

@AutoConfiguration
@ConditionalOnClass(value={ServletRequest.class, Undertow.class, SslClientAuthMode.class, DeploymentInfo.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={UndertowServerProperties.class})
@Import(value={UndertowWebServerConfiguration.class, ServletWebServerConfiguration.class})
public class UndertowServletWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    UndertowServletWebServerFactory undertowServletWebServerFactory(ObjectProvider<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers, ObjectProvider<UndertowBuilderCustomizer> builderCustomizers) {
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        factory.getDeploymentInfoCustomizers().addAll(deploymentInfoCustomizers.orderedStream().toList());
        factory.getBuilderCustomizers().addAll(builderCustomizers.orderedStream().toList());
        return factory;
    }

    @Bean
    UndertowServletWebServerFactoryCustomizer undertowServletWebServerFactoryCustomizer(UndertowServerProperties undertowProperties) {
        return new UndertowServletWebServerFactoryCustomizer(undertowProperties);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    UndertowDeploymentInfoCustomizer virtualThreadsUndertowDeploymentInfoCustomizer() {
        return deploymentInfo -> deploymentInfo.setExecutor((Executor)new VirtualThreadTaskExecutor("undertow-"));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Bootstrap.class})
    static class UndertowWebSocketConfiguration {
        UndertowWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketServletWebServerCustomizer"})
        WebSocketUndertowServletWebServerFactoryCustomizer websocketServletWebServerCustomizer() {
            return new WebSocketUndertowServletWebServerFactoryCustomizer();
        }
    }
}

