/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.StringUtils;

class DockerEnvironmentNotFoundFailureAnalyzer
extends AbstractFailureAnalyzer<IllegalStateException> {
    private static final String EXPECTED_MESSAGE = "Could not find a valid Docker environment";
    private static final String DESCRIPTION = "Could not find a valid Docker environment for Testcontainers.";
    private static final String ACTION = "    - Ensure a Docker-compatible container engine is installed and running.\n    - If running Testcontainers in CI, ensure the runner has access to the daemon, typically by using a mounted socket or a Docker-in-Docker setup.\n    - Review the Testcontainers documentation for troubleshooting and advanced configuration options.\n";

    DockerEnvironmentNotFoundFailureAnalyzer() {
    }

    protected @Nullable FailureAnalysis analyze(Throwable rootFailure, IllegalStateException cause) {
        if (StringUtils.hasText((String)cause.getMessage()) && cause.getMessage().contains(EXPECTED_MESSAGE)) {
            return new FailureAnalysis(DESCRIPTION, ACTION, (Throwable)cause);
        }
        return null;
    }
}

