/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.testcontainers.service.connection.FieldOrigin;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.boot.testcontainers.service.connection.ServiceConnectionContextCustomizer;
import org.springframework.boot.testcontainers.service.connection.SslBundleSource;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.containers.Container;

class ServiceConnectionContextCustomizerFactory
implements ContextCustomizerFactory {
    ServiceConnectionContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ArrayList sources = new ArrayList();
        this.collectSources(testClass, sources);
        return new ServiceConnectionContextCustomizer(sources);
    }

    private void collectSources(@Nullable Class<?> candidate, List<ContainerConnectionSource<?>> sources) {
        if (candidate == Object.class || candidate == null) {
            return;
        }
        ReflectionUtils.doWithLocalFields(candidate, field -> {
            MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)field);
            annotations.stream(ServiceConnection.class).forEach(serviceConnection -> sources.add(this.createSource(field, annotations, (MergedAnnotation<ServiceConnection>)serviceConnection)));
        });
        if (TestContextAnnotationUtils.searchEnclosingClass(candidate)) {
            this.collectSources(candidate.getEnclosingClass(), sources);
        }
        for (Class<?> implementedInterface : candidate.getInterfaces()) {
            this.collectSources(implementedInterface, sources);
        }
        this.collectSources(candidate.getSuperclass(), sources);
    }

    private <C extends Container<?>> ContainerConnectionSource<?> createSource(Field field, MergedAnnotations annotations, MergedAnnotation<ServiceConnection> serviceConnection) {
        Assert.state((boolean)Modifier.isStatic(field.getModifiers()), () -> "@ServiceConnection field '%s' must be static".formatted(field.getName()));
        FieldOrigin origin = new FieldOrigin(field);
        Object fieldValue = this.getFieldValue(field);
        Assert.state((boolean)(fieldValue instanceof Container), () -> "Field '%s' in %s must be a %s".formatted(field.getName(), field.getDeclaringClass().getName(), Container.class.getName()));
        Class<?> containerType = fieldValue.getClass();
        Container container = (Container)fieldValue;
        String dockerImageName = this.isAotProcessingInProgress() ? null : container.getDockerImageName();
        return new ContainerConnectionSource<Container>("test", (Origin)origin, containerType, dockerImageName, serviceConnection, () -> container, SslBundleSource.get(annotations), annotations);
    }

    private @Nullable Object getFieldValue(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, null);
    }

    private boolean isAotProcessingInProgress() {
        return Boolean.getBoolean("spring.aot.processing");
    }
}

