/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.hazelcast;

import com.hazelcast.client.config.ClientConfig;
import java.util.Map;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class HazelcastContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, HazelcastConnectionDetails> {
    private static final int DEFAULT_PORT = 5701;
    private static final String CLUSTER_NAME_ENV = "HZ_CLUSTERNAME";

    HazelcastContainerConnectionDetailsFactory() {
        super("hazelcast/hazelcast", "com.hazelcast.client.config.ClientConfig");
    }

    @Override
    protected HazelcastConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new HazelcastContainerConnectionDetails(source);
    }

    private static final class HazelcastContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements HazelcastConnectionDetails {
        private HazelcastContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public ClientConfig getClientConfig() {
            ClientConfig config = new ClientConfig();
            Object container = this.getContainer();
            Map env = container.getEnvMap();
            String clusterName = (String)env.get(HazelcastContainerConnectionDetailsFactory.CLUSTER_NAME_ENV);
            if (clusterName != null) {
                config.setClusterName(clusterName);
            }
            config.getNetworkConfig().addAddress(new String[]{container.getHost() + ":" + container.getMappedPort(5701)});
            return config;
        }
    }
}

