/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.MySQLR2DBCDatabaseContainer;

class MySqlR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MySQLContainer<?>, R2dbcConnectionDetails> {
    MySqlR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MySQLContainer<?>> source) {
        return new MySqlR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class MySqlR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MySQLContainer<?>>
    implements R2dbcConnectionDetails {
        private MySqlR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<MySQLContainer<?>> source) {
            super(source);
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MySQLR2DBCDatabaseContainer.getOptions((MySQLContainer)((MySQLContainer)this.getContainer()));
        }
    }
}

