/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class AnnotatedClassFinder {
    private static final Map<String, Class<?>> cache = Collections.synchronizedMap(new Cache(40));
    private final Class<? extends Annotation> annotationType;
    private final ClassPathScanningCandidateComponentProvider scanner;

    public AnnotatedClassFinder(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"AnnotationType must not be null");
        this.annotationType = annotationType;
        this.scanner = new ClassPathScanningCandidateComponentProvider(false);
        this.scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        this.scanner.setResourcePattern("*.class");
    }

    public Class<?> findFromClass(Class<?> source) {
        Assert.notNull(source, (String)"Source must not be null");
        return this.findFromPackage(ClassUtils.getPackageName(source));
    }

    public Class<?> findFromPackage(String source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Class<?> configuration = cache.get(source);
        if (configuration == null) {
            configuration = this.scanPackage(source);
            cache.put(source, configuration);
        }
        return configuration;
    }

    private Class<?> scanPackage(String source) {
        while (!source.isEmpty()) {
            Set components = this.scanner.findCandidateComponents(source);
            if (!components.isEmpty()) {
                Assert.state((components.size() == 1 ? 1 : 0) != 0, () -> "Found multiple @" + this.annotationType.getSimpleName() + " annotated classes " + String.valueOf(components));
                return ClassUtils.resolveClassName((String)((BeanDefinition)components.iterator().next()).getBeanClassName(), null);
            }
            source = this.getParentPackage(source);
        }
        return null;
    }

    private String getParentPackage(String sourcePackage) {
        int lastDot = sourcePackage.lastIndexOf(46);
        return lastDot != -1 ? sourcePackage.substring(0, lastDot) : "";
    }

    private static class Cache
    extends LinkedHashMap<String, Class<?>> {
        private final int maxSize;

        Cache(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Class<?>> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

