/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportMessage;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class OnFailureConditionReportContextCustomizerFactory
implements ContextCustomizerFactory {
    OnFailureConditionReportContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        return new OnFailureConditionReportContextCustomizer();
    }

    static class OnFailureConditionReportContextCustomizer
    implements ContextCustomizer {
        OnFailureConditionReportContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            Supplier<ConditionEvaluationReport> reportSupplier;
            if (context instanceof GenericApplicationContext) {
                ConditionEvaluationReport report = ConditionEvaluationReport.get((ConfigurableListableBeanFactory)context.getBeanFactory());
                reportSupplier = () -> report;
            } else {
                reportSupplier = () -> ConditionEvaluationReport.get((ConfigurableListableBeanFactory)context.getBeanFactory());
            }
            context.addApplicationListener((ApplicationListener)new ApplicationFailureListener(reportSupplier));
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static final class ApplicationFailureListener
    implements ApplicationListener<ApplicationFailedEvent> {
        private final Supplier<ConditionEvaluationReport> reportSupplier;

        private ApplicationFailureListener(Supplier<ConditionEvaluationReport> reportSupplier) {
            this.reportSupplier = reportSupplier;
        }

        public void onApplicationEvent(ApplicationFailedEvent event) {
            if (ApplicationFailureListener.shouldPrintReport(event.getApplicationContext())) {
                System.err.println(new ConditionEvaluationReportMessage(this.reportSupplier.get()));
            }
        }

        private static boolean shouldPrintReport(@Nullable ConfigurableApplicationContext context) {
            return context == null || (Boolean)context.getEnvironment().getProperty("spring.test.print-condition-evaluation-report", Boolean.class, (Object)true) != false;
        }
    }
}

