/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.graphql;

import graphql.execution.instrumentation.Instrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.graphql.autoconfigure.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.graphql.GraphQlTest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class GraphQlTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<GraphQlTest> {
    private static final Class<?>[] NO_CONTROLLERS = new Class[0];
    private static final String[] OPTIONAL_INCLUDES = new String[]{"com.fasterxml.jackson.databind.Module"};
    private static final Set<Class<?>> DEFAULT_INCLUDES;
    private static final Set<Class<?>> DEFAULT_INCLUDES_AND_CONTROLLER;
    private final Class<?>[] controllers = this.getAnnotation().getValue("controllers", Class[].class).orElse(NO_CONTROLLERS);

    GraphQlTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        if (ObjectUtils.isEmpty((Object[])this.controllers)) {
            return DEFAULT_INCLUDES_AND_CONTROLLER;
        }
        return DEFAULT_INCLUDES;
    }

    @Override
    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.controllers));
    }

    static {
        LinkedHashSet<Object> includes = new LinkedHashSet<Class>();
        includes.add(JsonComponent.class);
        includes.add(RuntimeWiringConfigurer.class);
        includes.add(Converter.class);
        includes.add(GenericConverter.class);
        includes.add(DataFetcherExceptionResolver.class);
        includes.add(Instrumentation.class);
        includes.add(GraphQlSourceBuilderCustomizer.class);
        for (String optionalInclude : OPTIONAL_INCLUDES) {
            try {
                includes.add(ClassUtils.forName((String)optionalInclude, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
        includes = new LinkedHashSet(DEFAULT_INCLUDES);
        includes.add(Controller.class);
        DEFAULT_INCLUDES_AND_CONTROLLER = Collections.unmodifiableSet(includes);
    }
}

