/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.reactive;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.test.autoconfigure.web.reactive.SpringBootWebTestClientBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.web.reactive.WebTestClientSecurityConfiguration;
import org.springframework.boot.web.server.test.client.reactive.WebTestClientBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebHandler;

@AutoConfiguration(afterName={"org.springframework.boot.http.codec.autoconfigure.CodecsAutoConfiguration", "org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration"})
@ConditionalOnClass(value={WebClient.class, WebTestClient.class})
@Import(value={WebTestClientSecurityConfiguration.class})
@EnableConfigurationProperties
public class WebTestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WebHandler.class})
    public WebTestClient webTestClient(ApplicationContext applicationContext, List<WebTestClientBuilderCustomizer> customizers, List<MockServerConfigurer> configurers) {
        WebTestClient.MockServerSpec mockServerSpec = WebTestClient.bindToApplicationContext((ApplicationContext)applicationContext);
        for (MockServerConfigurer configurer : configurers) {
            mockServerSpec.apply(configurer);
        }
        WebTestClient.Builder builder = mockServerSpec.configureClient();
        for (WebTestClientBuilderCustomizer customizer : customizers) {
            customizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConfigurationProperties(value="spring.test.webtestclient")
    public SpringBootWebTestClientBuilderCustomizer springBootWebTestClientBuilderCustomizer(ObjectProvider<CodecCustomizer> codecCustomizers) {
        return new SpringBootWebTestClientBuilderCustomizer(codecCustomizers.orderedStream().toList());
    }
}

