/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.endpoint;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.session.endpoint.SessionsDescriptor;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

@Endpoint(id="sessions")
public class SessionsEndpoint {
    private final SessionRepository<? extends Session> sessionRepository;
    private final @Nullable FindByIndexNameSessionRepository<? extends Session> indexedSessionRepository;

    public SessionsEndpoint(SessionRepository<? extends Session> sessionRepository, @Nullable FindByIndexNameSessionRepository<? extends Session> indexedSessionRepository) {
        Assert.notNull(sessionRepository, (String)"'sessionRepository' must not be null");
        this.sessionRepository = sessionRepository;
        this.indexedSessionRepository = indexedSessionRepository;
    }

    @ReadOperation
    public @Nullable SessionsDescriptor sessionsForUsername(String username) {
        if (this.indexedSessionRepository == null) {
            return null;
        }
        Map sessions = this.indexedSessionRepository.findByPrincipalName(username);
        return new SessionsDescriptor(sessions);
    }

    @ReadOperation
    public @Nullable SessionsDescriptor.SessionDescriptor getSession(@Selector String sessionId) {
        Session session = this.sessionRepository.findById(sessionId);
        if (session == null) {
            return null;
        }
        return new SessionsDescriptor.SessionDescriptor(session);
    }

    @DeleteOperation
    public void deleteSession(@Selector String sessionId) {
        this.sessionRepository.deleteById(sessionId);
    }
}

