/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.servlet;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.security.autoconfigure.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class SpringBootWebSecurityConfiguration {
    SpringBootWebSecurityConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(name={"springSecurityFilterChain"})
    @ConditionalOnClass(value={EnableWebSecurity.class})
    @EnableWebSecurity
    static class WebSecurityEnablerConfiguration {
        WebSecurityEnablerConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDefaultWebSecurity
    static class SecurityFilterChainConfiguration {
        SecurityFilterChainConfiguration() {
        }

        @Bean
        @Order(value=0x7FFFFFFA)
        SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
            http.formLogin(Customizer.withDefaults());
            http.httpBasic(Customizer.withDefaults());
            return (SecurityFilterChain)http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={DispatcherServletPath.class})
    @ConditionalOnClass(value={DispatcherServletPath.class})
    static class PathPatternRequestMatcherBuilderConfiguration {
        PathPatternRequestMatcherBuilderConfiguration() {
        }

        @Bean
        static BeanPostProcessor pathPatternRequestMatcherBuilderBasePathCustomizer(final ObjectProvider<DispatcherServletPath> dispatcherServletPath) {
            return new BeanPostProcessor(){

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if ("pathPatternRequestMatcherBuilder".equals(beanName) && bean instanceof PathPatternRequestMatcher.Builder) {
                        PathPatternRequestMatcher.Builder builder = (PathPatternRequestMatcher.Builder)bean;
                        String path = ((DispatcherServletPath)dispatcherServletPath.getObject()).getPath();
                        if (!path.equals("/")) {
                            return builder.basePath(path);
                        }
                    }
                    return bean;
                }
            };
        }
    }
}

