/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.server.resource.autoconfigure.reactive;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.ConditionalOnIssuerLocationJwtDecoder;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.ConditionalOnPublicKeyJwtDecoder;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.OAuth2ResourceServerProperties;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.reactive.JwkSetUriReactiveJwtDecoderBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.SupplierReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtGrantedAuthoritiesConverterAdapter;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
class ReactiveOAuth2ResourceServerJwkConfiguration {
    ReactiveOAuth2ResourceServerJwkConfiguration() {
    }

    private static class JwtConverterPropertiesCondition
    extends AnyNestedCondition {
        JwtConverterPropertiesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.authorities-claim-name"})
        static class OnAuthoritiesClaimName {
            OnAuthoritiesClaimName() {
            }
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.principal-claim-name"})
        static class OnPrincipalClaimName {
            OnPrincipalClaimName() {
            }
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.authority-prefix"})
        static class OnAuthorityPrefix {
            OnAuthorityPrefix() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={SecurityWebFilterChain.class})
    static class WebSecurityConfiguration {
        WebSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ReactiveJwtDecoder.class})
        SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, ReactiveJwtDecoder jwtDecoder) {
            http.authorizeExchange(exchanges -> exchanges.anyExchange().authenticated());
            http.oauth2ResourceServer(server -> this.customDecoder((ServerHttpSecurity.OAuth2ResourceServerSpec)server, jwtDecoder));
            return http.build();
        }

        private void customDecoder(ServerHttpSecurity.OAuth2ResourceServerSpec server, ReactiveJwtDecoder decoder) {
            server.jwt(jwt -> jwt.jwtDecoder(decoder));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ReactiveJwtAuthenticationConverter.class})
    @Conditional(value={JwtConverterPropertiesCondition.class})
    static class JwtConverterConfiguration {
        private final OAuth2ResourceServerProperties.Jwt properties;

        JwtConverterConfiguration(OAuth2ResourceServerProperties properties) {
            this.properties = properties.getJwt();
        }

        @Bean
        ReactiveJwtAuthenticationConverter reactiveJwtAuthenticationConverter() {
            JwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
            PropertyMapper map = PropertyMapper.get();
            map.from((Object)this.properties.getAuthorityPrefix()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthorityPrefix(arg_0));
            map.from((Object)this.properties.getAuthoritiesClaimDelimiter()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimDelimiter(arg_0));
            map.from((Object)this.properties.getAuthoritiesClaimName()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimName(arg_0));
            ReactiveJwtAuthenticationConverter jwtAuthenticationConverter = new ReactiveJwtAuthenticationConverter();
            map.from((Object)this.properties.getPrincipalClaimName()).to(arg_0 -> ((ReactiveJwtAuthenticationConverter)jwtAuthenticationConverter).setPrincipalClaimName(arg_0));
            jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new ReactiveJwtGrantedAuthoritiesConverterAdapter((Converter)grantedAuthoritiesConverter));
            return jwtAuthenticationConverter;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ReactiveJwtDecoder.class})
    static class JwtConfiguration {
        private final OAuth2ResourceServerProperties.Jwt properties;
        private final List<OAuth2TokenValidator<Jwt>> additionalValidators;

        JwtConfiguration(OAuth2ResourceServerProperties properties, ObjectProvider<OAuth2TokenValidator<Jwt>> additionalValidators) {
            this.properties = properties.getJwt();
            this.additionalValidators = additionalValidators.orderedStream().toList();
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
        ReactiveJwtDecoder jwtDecoder(ObjectProvider<JwkSetUriReactiveJwtDecoderBuilderCustomizer> customizers) {
            String jwkSetUri = this.properties.getJwkSetUri();
            Assert.state((jwkSetUri != null ? 1 : 0) != 0, (String)"'jwkSetUri' must not be null");
            NimbusReactiveJwtDecoder.JwkSetUriReactiveJwtDecoderBuilder builder = NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithms(this::jwsAlgorithms);
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            NimbusReactiveJwtDecoder nimbusReactiveJwtDecoder = builder.build();
            String issuerUri = this.properties.getIssuerUri();
            ArrayList<Object> validators = new ArrayList<Object>();
            if (issuerUri != null) {
                validators.add(new JwtIssuerValidator(issuerUri));
            }
            validators.addAll(this.getValidators());
            nimbusReactiveJwtDecoder.setJwtValidator(validators.isEmpty() ? JwtValidators.createDefault() : JwtValidators.createDefaultWithValidators(validators));
            return nimbusReactiveJwtDecoder;
        }

        private void jwsAlgorithms(Set<SignatureAlgorithm> signatureAlgorithms) {
            for (String algorithm : this.properties.getJwsAlgorithms()) {
                signatureAlgorithms.add(SignatureAlgorithm.from((String)algorithm));
            }
        }

        private List<OAuth2TokenValidator<Jwt>> getValidators() {
            List<String> audiences = this.properties.getAudiences();
            if (CollectionUtils.isEmpty(audiences) && this.additionalValidators.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<OAuth2TokenValidator<Jwt>> validators = new ArrayList<OAuth2TokenValidator<Jwt>>();
            if (!CollectionUtils.isEmpty(audiences)) {
                validators.add((OAuth2TokenValidator<Jwt>)this.audValidator(audiences));
            }
            validators.addAll(this.additionalValidators);
            return validators;
        }

        private JwtClaimValidator<List<String>> audValidator(List<String> audiences) {
            return new JwtClaimValidator("aud", aud -> this.nullSafeDisjoint((List<String>)aud, audiences));
        }

        private boolean nullSafeDisjoint(@Nullable List<String> c1, List<String> c2) {
            return c1 != null && !Collections.disjoint(c1, c2);
        }

        @Bean
        @ConditionalOnPublicKeyJwtDecoder
        NimbusReactiveJwtDecoder jwtDecoderByPublicKeyValue() throws Exception {
            RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
            NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withPublicKey((RSAPublicKey)publicKey).signatureAlgorithm(SignatureAlgorithm.from((String)this.exactlyOneAlgorithm())).build();
            List<OAuth2TokenValidator<Jwt>> validators = this.getValidators();
            jwtDecoder.setJwtValidator(validators.isEmpty() ? JwtValidators.createDefault() : JwtValidators.createDefaultWithValidators(validators));
            return jwtDecoder;
        }

        private byte[] getKeySpec(String keyValue) {
            keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            return Base64.getMimeDecoder().decode(keyValue);
        }

        private String exactlyOneAlgorithm() {
            int count;
            List<String> algorithms = this.properties.getJwsAlgorithms();
            int n = count = algorithms != null ? algorithms.size() : 0;
            if (count != 1) {
                throw new IllegalStateException("Creating a JWT decoder using a public key requires exactly one JWS algorithm but " + count + " were configured");
            }
            return algorithms.get(0);
        }

        @Bean
        @ConditionalOnIssuerLocationJwtDecoder
        SupplierReactiveJwtDecoder jwtDecoderByIssuerUri(ObjectProvider<JwkSetUriReactiveJwtDecoderBuilderCustomizer> customizers) {
            return new SupplierReactiveJwtDecoder(() -> {
                String issuerUri = this.properties.getIssuerUri();
                Assert.state((issuerUri != null ? 1 : 0) != 0, (String)"'issuerUri' must not be null");
                NimbusReactiveJwtDecoder.JwkSetUriReactiveJwtDecoderBuilder builder = NimbusReactiveJwtDecoder.withIssuerLocation((String)issuerUri);
                customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
                NimbusReactiveJwtDecoder jwtDecoder = builder.build();
                ArrayList<Object> validators = new ArrayList<Object>();
                validators.add(new JwtIssuerValidator(issuerUri));
                validators.addAll(this.getValidators());
                jwtDecoder.setJwtValidator(JwtValidators.createDefaultWithValidators(validators));
                return jwtDecoder;
            });
        }
    }
}

