/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.autoconfigure;

import java.net.InetAddress;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="spring.rsocket")
public class RSocketProperties {
    @NestedConfigurationProperty
    private final Server server = new Server();

    public Server getServer() {
        return this.server;
    }

    public static class Server {
        private @Nullable Integer port;
        private @Nullable InetAddress address;
        private RSocketServer.Transport transport = RSocketServer.Transport.TCP;
        private @Nullable String mappingPath;
        private @Nullable DataSize fragmentSize;
        @NestedConfigurationProperty
        private @Nullable Ssl ssl;
        private final Spec spec = new Spec();

        public @Nullable Integer getPort() {
            return this.port;
        }

        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        public @Nullable InetAddress getAddress() {
            return this.address;
        }

        public void setAddress(@Nullable InetAddress address) {
            this.address = address;
        }

        public RSocketServer.Transport getTransport() {
            return this.transport;
        }

        public void setTransport(RSocketServer.Transport transport) {
            this.transport = transport;
        }

        public @Nullable String getMappingPath() {
            return this.mappingPath;
        }

        public void setMappingPath(@Nullable String mappingPath) {
            this.mappingPath = mappingPath;
        }

        public @Nullable DataSize getFragmentSize() {
            return this.fragmentSize;
        }

        public void setFragmentSize(@Nullable DataSize fragmentSize) {
            this.fragmentSize = fragmentSize;
        }

        public @Nullable Ssl getSsl() {
            return this.ssl;
        }

        public void setSsl(@Nullable Ssl ssl) {
            this.ssl = ssl;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public static class Spec {
            private @Nullable String protocols;
            private DataSize maxFramePayloadLength = DataSize.ofBytes((long)65536L);
            private boolean handlePing;
            private boolean compress;

            public @Nullable String getProtocols() {
                return this.protocols;
            }

            public void setProtocols(@Nullable String protocols) {
                this.protocols = protocols;
            }

            public DataSize getMaxFramePayloadLength() {
                return this.maxFramePayloadLength;
            }

            public void setMaxFramePayloadLength(DataSize maxFramePayloadLength) {
                this.maxFramePayloadLength = maxFramePayloadLength;
            }

            public boolean isHandlePing() {
                return this.handlePing;
            }

            public void setHandlePing(boolean handlePing) {
                this.handlePing = handlePing;
            }

            public boolean isCompress() {
                return this.compress;
            }

            public void setCompress(boolean compress) {
                this.compress = compress;
            }
        }
    }
}

