/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restdocs.test.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsMockMvcBuilderCustomizer;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsMockMvcConfigurationCustomizer;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsProperties;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsWebTestClientBuilderCustomizer;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsWebTestClientConfigurationCustomizer;
import org.springframework.boot.webtestclient.WebTestClientBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentation;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;

@AutoConfiguration
@ConditionalOnWebApplication
public final class RestDocsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebTestClientRestDocumentation.class, WebTestClientBuilderCustomizer.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @EnableConfigurationProperties(value={RestDocsProperties.class})
    static class RestDocsWebTestClientConfiguration {
        RestDocsWebTestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        WebTestClientRestDocumentationConfigurer restDocsWebTestClientConfigurer(ObjectProvider<RestDocsWebTestClientConfigurationCustomizer> configurationCustomizers, RestDocumentationContextProvider contextProvider) {
            WebTestClientRestDocumentationConfigurer configurer = WebTestClientRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
            configurationCustomizers.orderedStream().forEach(configurationCustomizer -> configurationCustomizer.customize(configurer));
            return configurer;
        }

        @Bean
        RestDocsWebTestClientBuilderCustomizer restDocumentationConfigurer(RestDocsProperties properties, WebTestClientRestDocumentationConfigurer configurer) {
            return new RestDocsWebTestClientBuilderCustomizer(properties, configurer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MockMvcRestDocumentation.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableConfigurationProperties(value={RestDocsProperties.class})
    static class RestDocsMockMvcConfiguration {
        RestDocsMockMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MockMvcRestDocumentationConfigurer restDocsMockMvcConfigurer(ObjectProvider<RestDocsMockMvcConfigurationCustomizer> configurationCustomizers, RestDocumentationContextProvider contextProvider) {
            MockMvcRestDocumentationConfigurer configurer = MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
            configurationCustomizers.orderedStream().forEach(configurationCustomizer -> configurationCustomizer.customize(configurer));
            return configurer;
        }

        @Bean
        RestDocsMockMvcBuilderCustomizer restDocumentationConfigurer(RestDocsProperties properties, MockMvcRestDocumentationConfigurer configurer, ObjectProvider<RestDocumentationResultHandler> resultHandler) {
            return new RestDocsMockMvcBuilderCustomizer(properties, configurer, (RestDocumentationResultHandler)resultHandler.getIfAvailable());
        }
    }
}

