/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.boot.restclient.RestTemplateRequestCustomizer;
import org.springframework.util.ObjectUtils;

public final class RestTemplateBuilderConfigurer {
    private @Nullable ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;
    private @Nullable ClientHttpRequestFactorySettings requestFactorySettings;
    private @Nullable HttpMessageConverters httpMessageConverters;
    private @Nullable List<RestTemplateCustomizer> restTemplateCustomizers;
    private @Nullable List<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers;

    void setRequestFactoryBuilder(@Nullable ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder) {
        this.requestFactoryBuilder = requestFactoryBuilder;
    }

    void setRequestFactorySettings(@Nullable ClientHttpRequestFactorySettings requestFactorySettings) {
        this.requestFactorySettings = requestFactorySettings;
    }

    void setHttpMessageConverters(@Nullable HttpMessageConverters httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
    }

    void setRestTemplateCustomizers(@Nullable List<RestTemplateCustomizer> restTemplateCustomizers) {
        this.restTemplateCustomizers = restTemplateCustomizers;
    }

    void setRestTemplateRequestCustomizers(@Nullable List<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers) {
        this.restTemplateRequestCustomizers = restTemplateRequestCustomizers;
    }

    public RestTemplateBuilder configure(RestTemplateBuilder builder) {
        if (this.requestFactoryBuilder != null) {
            builder = builder.requestFactoryBuilder(this.requestFactoryBuilder);
        }
        if (this.requestFactorySettings != null) {
            builder = builder.requestFactorySettings(this.requestFactorySettings);
        }
        if (this.httpMessageConverters != null) {
            builder = builder.messageConverters(this.httpMessageConverters.getConverters());
        }
        builder = this.addCustomizers(builder, this.restTemplateCustomizers, RestTemplateBuilder::customizers);
        builder = this.addCustomizers(builder, this.restTemplateRequestCustomizers, RestTemplateBuilder::requestCustomizers);
        return builder;
    }

    private <T> RestTemplateBuilder addCustomizers(RestTemplateBuilder builder, @Nullable List<T> customizers, BiFunction<RestTemplateBuilder, Collection<T>, RestTemplateBuilder> method) {
        if (!ObjectUtils.isEmpty(customizers)) {
            return method.apply(builder, customizers);
        }
        return builder;
    }
}

