/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.autoconfigure.AbstractHttpRequestFactoryProperties;
import org.springframework.boot.http.client.autoconfigure.ClientHttpRequestFactories;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.restclient.autoconfigure.service.HttpClientServiceProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class RestClientPropertiesHttpServiceGroupConfigurer
implements RestClientHttpServiceGroupConfigurer {
    private final ClassLoader classLoader;
    private final ObjectProvider<SslBundles> sslBundles;
    private final HttpClientProperties clientProperties;
    private final HttpClientServiceProperties serviceProperties;
    private final ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder;
    private final ObjectProvider<ClientHttpRequestFactorySettings> requestFactorySettings;

    RestClientPropertiesHttpServiceGroupConfigurer(ClassLoader classLoader, ObjectProvider<SslBundles> sslBundles, HttpClientProperties clientProperties, HttpClientServiceProperties serviceProperties, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> requestFactorySettings) {
        this.classLoader = classLoader;
        this.sslBundles = sslBundles;
        this.clientProperties = clientProperties;
        this.serviceProperties = serviceProperties;
        this.requestFactoryBuilder = requestFactoryBuilder;
        this.requestFactorySettings = requestFactorySettings;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<RestClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, RestClient.Builder builder) {
        HttpClientServiceProperties.Group groupProperties = this.serviceProperties.getGroup().get(group.name());
        builder.requestFactory(this.getRequestFactory(groupProperties));
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serviceProperties::getBaseUrl).whenHasText().to(arg_0 -> ((RestClient.Builder)builder).baseUrl(arg_0));
        map.from(this.serviceProperties::getDefaultHeader).as(this::putAllHeaders).to(arg_0 -> ((RestClient.Builder)builder).defaultHeaders(arg_0));
        if (groupProperties != null) {
            map.from(groupProperties::getBaseUrl).whenHasText().to(arg_0 -> ((RestClient.Builder)builder).baseUrl(arg_0));
            map.from(groupProperties::getDefaultHeader).as(this::putAllHeaders).to(arg_0 -> ((RestClient.Builder)builder).defaultHeaders(arg_0));
        }
    }

    private Consumer<HttpHeaders> putAllHeaders(Map<String, List<String>> defaultHeaders) {
        return httpHeaders -> httpHeaders.putAll(defaultHeaders);
    }

    private ClientHttpRequestFactory getRequestFactory(HttpClientServiceProperties.Group groupProperties) {
        ClientHttpRequestFactories factories = new ClientHttpRequestFactories(this.sslBundles, new AbstractHttpRequestFactoryProperties[]{groupProperties, this.serviceProperties, this.clientProperties});
        ClientHttpRequestFactoryBuilder builder = (ClientHttpRequestFactoryBuilder)this.requestFactoryBuilder.getIfAvailable(() -> factories.builder(this.classLoader));
        ClientHttpRequestFactorySettings settings = (ClientHttpRequestFactorySettings)this.requestFactorySettings.getIfAvailable(() -> ((ClientHttpRequestFactories)factories).settings());
        return builder.build(settings);
    }
}

