/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.web.client.RestClient;

public class RestClientBuilderConfigurer {
    private final ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;
    private final ClientHttpRequestFactorySettings requestFactorySettings;
    private final List<RestClientCustomizer> customizers;

    public RestClientBuilderConfigurer() {
        this(ClientHttpRequestFactoryBuilder.detect(), ClientHttpRequestFactorySettings.defaults(), Collections.emptyList());
    }

    RestClientBuilderConfigurer(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder, ClientHttpRequestFactorySettings requestFactorySettings, List<RestClientCustomizer> customizers) {
        this.requestFactoryBuilder = requestFactoryBuilder;
        this.requestFactorySettings = requestFactorySettings;
        this.customizers = customizers;
    }

    public RestClient.Builder configure(RestClient.Builder builder) {
        builder.requestFactory(this.requestFactoryBuilder.build(this.requestFactorySettings));
        this.applyCustomizers(builder);
        return builder;
    }

    private void applyCustomizers(RestClient.Builder builder) {
        for (RestClientCustomizer customizer : this.customizers) {
            customizer.customize(builder);
        }
    }
}

