/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OracleEnvironment {
    private final String username;
    private final String password;
    private final String database;

    OracleEnvironment(Map<String, @Nullable String> env, String defaultDatabase) {
        this.username = OracleEnvironment.extractUsername(env);
        this.password = this.extractPassword(env);
        this.database = OracleEnvironment.extractDatabase(env, defaultDatabase);
    }

    private static String extractDatabase(Map<String, @Nullable String> env, String defaultDatabase) {
        String result = env.get("ORACLE_DATABASE");
        return result != null ? result : defaultDatabase;
    }

    private static String extractUsername(Map<String, @Nullable String> env) {
        String result = env.get("APP_USER");
        return result != null ? result : "system";
    }

    private String extractPassword(Map<String, @Nullable String> env) {
        if (env.containsKey("APP_USER")) {
            String password = env.get("APP_USER_PASSWORD");
            Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No Oracle app password found");
            return password;
        }
        Assert.state((!env.containsKey("ORACLE_RANDOM_PASSWORD") ? 1 : 0) != 0, (String)"ORACLE_RANDOM_PASSWORD is not supported without APP_USER and APP_USER_PASSWORD");
        String password = env.get("ORACLE_PASSWORD");
        Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No Oracle password found");
        return password;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

