/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.r2dbc.autoconfigure.ConnectionFactoryConfigurations;
import org.springframework.boot.r2dbc.autoconfigure.ConnectionFactoryDependentConfiguration;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcInitializationAutoConfiguration;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={R2dbcInitializationAutoConfiguration.class}, beforeName={"org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration"})
@ConditionalOnClass(value={ConnectionFactory.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/io.r2dbc.spi.ConnectionFactoryProvider"})
@EnableConfigurationProperties(value={R2dbcProperties.class})
@Import(value={ConnectionFactoryConfigurations.PoolConfiguration.class, ConnectionFactoryConfigurations.GenericConfiguration.class, ConnectionFactoryDependentConfiguration.class})
public final class R2dbcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={R2dbcConnectionDetails.class})
    @ConditionalOnProperty(value={"spring.r2dbc.url"})
    PropertiesR2dbcConnectionDetails propertiesR2dbcConnectionDetails(R2dbcProperties properties) {
        return new PropertiesR2dbcConnectionDetails(properties);
    }

    static class PropertiesR2dbcConnectionDetails
    implements R2dbcConnectionDetails {
        private final R2dbcProperties properties;

        PropertiesR2dbcConnectionDetails(R2dbcProperties properties) {
            this.properties = properties;
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            String url = this.properties.getUrl();
            Assert.state((url != null ? 1 : 0) != 0, (String)"'url' must not be null");
            ConnectionFactoryOptions urlOptions = ConnectionFactoryOptions.parse((CharSequence)url);
            ConnectionFactoryOptions.Builder optionsBuilder = urlOptions.mutate();
            this.configureUser(optionsBuilder, urlOptions);
            this.configurePassword(optionsBuilder, urlOptions);
            this.configureDatabase(optionsBuilder, urlOptions);
            this.properties.getProperties().forEach((key, value) -> optionsBuilder.option(Option.valueOf((String)key), value));
            return optionsBuilder.build();
        }

        private void configureDatabase(ConnectionFactoryOptions.Builder optionsBuilder, ConnectionFactoryOptions urlOptions) {
            Supplier<@Nullable String> getDatabaseName = () -> this.determineDatabaseName(this.properties);
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.DATABASE, getDatabaseName);
        }

        private void configurePassword(ConnectionFactoryOptions.Builder optionsBuilder, ConnectionFactoryOptions urlOptions) {
            Supplier<@Nullable CharSequence> getPassword = this.properties::getPassword;
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.PASSWORD, getPassword);
        }

        private void configureUser(ConnectionFactoryOptions.Builder optionsBuilder, ConnectionFactoryOptions urlOptions) {
            Supplier<@Nullable String> getUsername = this.properties::getUsername;
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.USER, getUsername);
        }

        private <T extends CharSequence> void configureIf(ConnectionFactoryOptions.Builder optionsBuilder, ConnectionFactoryOptions originalOptions, Option<T> option, Supplier<@Nullable T> valueSupplier) {
            if (originalOptions.hasOption(option)) {
                return;
            }
            CharSequence value = (CharSequence)valueSupplier.get();
            if (StringUtils.hasText((CharSequence)value)) {
                optionsBuilder.option(option, (Object)value);
            }
        }

        private @Nullable String determineDatabaseName(R2dbcProperties properties) {
            if (properties.isGenerateUniqueName()) {
                return properties.determineUniqueName();
            }
            if (StringUtils.hasLength((String)properties.getName())) {
                return properties.getName();
            }
            return null;
        }
    }
}

