/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure.observation;

import io.micrometer.observation.ObservationRegistry;
import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.observation.ObservationProxyExecutionListener;
import io.r2dbc.proxy.observation.QueryObservationConvention;
import io.r2dbc.proxy.observation.QueryParametersTagProvider;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.r2dbc.OptionsCapableConnectionFactory;
import org.springframework.boot.r2dbc.autoconfigure.ProxyConnectionFactoryCustomizer;
import org.springframework.boot.r2dbc.autoconfigure.observation.R2dbcObservationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(afterName={"org.springframework.boot.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnClass(value={ConnectionFactory.class, ProxyConnectionFactory.class, ObservationRegistry.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={R2dbcObservationProperties.class})
public class R2dbcObservationAutoConfiguration {
    public static final int R2DBC_PROXY_OBSERVATION_CUSTOMIZER_ORDER = 0;

    @Bean
    @Order(value=0)
    @ConditionalOnBean(value={ObservationRegistry.class})
    ProxyConnectionFactoryCustomizer observationProxyConnectionFactoryCustomizer(R2dbcObservationProperties properties, ObservationRegistry observationRegistry, ObjectProvider<QueryObservationConvention> queryObservationConvention, ObjectProvider<QueryParametersTagProvider> queryParametersTagProvider) {
        return builder -> {
            ConnectionFactory connectionFactory = builder.getConnectionFactory();
            HostAndPort hostAndPort = this.extractHostAndPort(connectionFactory);
            ObservationProxyExecutionListener listener = new ObservationProxyExecutionListener(observationRegistry, connectionFactory, hostAndPort.host(), hostAndPort.port());
            listener.setIncludeParameterValues(properties.isIncludeParameterValues());
            queryObservationConvention.ifAvailable(arg_0 -> ((ObservationProxyExecutionListener)listener).setQueryObservationConvention(arg_0));
            queryParametersTagProvider.ifAvailable(arg_0 -> ((ObservationProxyExecutionListener)listener).setQueryParametersTagProvider(arg_0));
            builder.listener((ProxyExecutionListener)listener);
        };
    }

    private HostAndPort extractHostAndPort(ConnectionFactory connectionFactory) {
        String hostAsString;
        Object port;
        block5: {
            block4: {
                OptionsCapableConnectionFactory optionsCapableConnectionFactory = OptionsCapableConnectionFactory.unwrapFrom(connectionFactory);
                if (optionsCapableConnectionFactory == null) {
                    return HostAndPort.empty();
                }
                ConnectionFactoryOptions options = optionsCapableConnectionFactory.getOptions();
                Object host = options.getValue(ConnectionFactoryOptions.HOST);
                port = options.getValue(ConnectionFactoryOptions.PORT);
                if (!(host instanceof String)) break block4;
                hostAsString = (String)host;
                if (port instanceof Integer) break block5;
            }
            return HostAndPort.empty();
        }
        Integer portAsInt = (Integer)port;
        return new HostAndPort(hostAsString, portAsInt);
    }

    private record HostAndPort(String host, Integer port) {
        static HostAndPort empty() {
            return new HostAndPort(null, null);
        }
    }
}

