/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.pulsar.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.pulsar.autoconfigure.PropertiesPulsarConnectionDetails;
import org.springframework.boot.pulsar.autoconfigure.PulsarConnectionDetails;
import org.springframework.boot.pulsar.autoconfigure.PulsarContainerFactoryCustomizer;
import org.springframework.boot.pulsar.autoconfigure.PulsarContainerFactoryCustomizers;
import org.springframework.boot.pulsar.autoconfigure.PulsarProperties;
import org.springframework.boot.pulsar.autoconfigure.PulsarPropertiesMapper;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.pulsar.annotation.EnablePulsar;
import org.springframework.pulsar.config.ConcurrentPulsarListenerContainerFactory;
import org.springframework.pulsar.config.DefaultPulsarReaderContainerFactory;
import org.springframework.pulsar.core.CachingPulsarProducerFactory;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.DefaultPulsarClientFactory;
import org.springframework.pulsar.core.DefaultPulsarConsumerFactory;
import org.springframework.pulsar.core.DefaultPulsarProducerFactory;
import org.springframework.pulsar.core.DefaultPulsarReaderFactory;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarAdminBuilderCustomizer;
import org.springframework.pulsar.core.PulsarAdministration;
import org.springframework.pulsar.core.PulsarClientBuilderCustomizer;
import org.springframework.pulsar.core.PulsarClientFactory;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.PulsarTemplate;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.function.PulsarFunction;
import org.springframework.pulsar.function.PulsarFunctionAdministration;
import org.springframework.pulsar.function.PulsarSink;
import org.springframework.pulsar.function.PulsarSource;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.pulsar.transaction.PulsarAwareTransactionManager;
import org.springframework.pulsar.transaction.PulsarTransactionManager;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnClass(value={PulsarClient.class, PulsarTemplate.class})
@EnableConfigurationProperties(value={PulsarProperties.class})
public final class PulsarAutoConfiguration {
    private final PulsarProperties properties;
    private final PulsarPropertiesMapper propertiesMapper;

    PulsarAutoConfiguration(PulsarProperties properties) {
        this.properties = properties;
        this.propertiesMapper = new PulsarPropertiesMapper(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarConnectionDetails.class})
    PropertiesPulsarConnectionDetails pulsarConnectionDetails() {
        return new PropertiesPulsarConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarClientFactory.class})
    DefaultPulsarClientFactory pulsarClientFactory(PulsarConnectionDetails connectionDetails, ObjectProvider<PulsarClientBuilderCustomizer> customizersProvider) {
        ArrayList<Object> allCustomizers = new ArrayList<Object>();
        allCustomizers.add(builder -> this.propertiesMapper.customizeClientBuilder(builder, connectionDetails));
        allCustomizers.addAll(customizersProvider.orderedStream().toList());
        DefaultPulsarClientFactory clientFactory = new DefaultPulsarClientFactory(clientBuilder -> this.applyClientBuilderCustomizers(allCustomizers, clientBuilder));
        return clientFactory;
    }

    private void applyClientBuilderCustomizers(List<PulsarClientBuilderCustomizer> customizers, ClientBuilder clientBuilder) {
        customizers.forEach(customizer -> customizer.customize(clientBuilder));
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarClient pulsarClient(PulsarClientFactory clientFactory) {
        return clientFactory.createClient();
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarAdministration pulsarAdministration(PulsarConnectionDetails connectionDetails, ObjectProvider<PulsarAdminBuilderCustomizer> pulsarAdminBuilderCustomizers) {
        ArrayList<Object> allCustomizers = new ArrayList<Object>();
        allCustomizers.add(builder -> this.propertiesMapper.customizeAdminBuilder(builder, connectionDetails));
        allCustomizers.addAll(pulsarAdminBuilderCustomizers.orderedStream().toList());
        return new PulsarAdministration(adminBuilder -> this.applyAdminBuilderCustomizers(allCustomizers, adminBuilder));
    }

    private void applyAdminBuilderCustomizers(List<PulsarAdminBuilderCustomizer> customizers, PulsarAdminBuilder adminBuilder) {
        customizers.forEach(customizer -> customizer.customize(adminBuilder));
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaResolver.class})
    DefaultSchemaResolver pulsarSchemaResolver(ObjectProvider<SchemaResolver.SchemaResolverCustomizer<?>> schemaResolverCustomizers) {
        DefaultSchemaResolver schemaResolver = new DefaultSchemaResolver();
        this.addCustomSchemaMappings(schemaResolver, this.properties.getDefaults().getTypeMappings());
        this.applySchemaResolverCustomizers(schemaResolverCustomizers.orderedStream().toList(), schemaResolver);
        return schemaResolver;
    }

    private void addCustomSchemaMappings(DefaultSchemaResolver schemaResolver, @Nullable List<PulsarProperties.Defaults.TypeMapping> typeMappings) {
        if (typeMappings != null) {
            typeMappings.forEach(typeMapping -> this.addCustomSchemaMapping(schemaResolver, (PulsarProperties.Defaults.TypeMapping)typeMapping));
        }
    }

    private void addCustomSchemaMapping(DefaultSchemaResolver schemaResolver, PulsarProperties.Defaults.TypeMapping typeMapping) {
        PulsarProperties.Defaults.SchemaInfo schemaInfo = typeMapping.schemaInfo();
        if (schemaInfo != null) {
            Class<?> messageType = typeMapping.messageType();
            SchemaType schemaType = schemaInfo.schemaType();
            Class<?> messageKeyType = schemaInfo.messageKeyType();
            Schema<Object> schema = this.getSchema(schemaResolver, schemaType, messageType, messageKeyType);
            schemaResolver.addCustomSchemaMapping(typeMapping.messageType(), schema);
        }
    }

    private Schema<Object> getSchema(DefaultSchemaResolver schemaResolver, SchemaType schemaType, Class<?> messageType, @Nullable Class<?> messageKeyType) {
        Schema schema = (Schema)schemaResolver.resolveSchema(schemaType, messageType, messageKeyType).orElseThrow();
        Assert.state((schema != null ? 1 : 0) != 0, (String)"'schema' must not be null");
        return schema;
    }

    private void applySchemaResolverCustomizers(List<SchemaResolver.SchemaResolverCustomizer<?>> customizers, DefaultSchemaResolver schemaResolver) {
        LambdaSafe.callbacks(SchemaResolver.SchemaResolverCustomizer.class, customizers, (Object)schemaResolver, (Object[])new Object[0]).invoke(customizer -> customizer.customize((SchemaResolver)schemaResolver));
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicResolver.class})
    DefaultTopicResolver pulsarTopicResolver() {
        DefaultTopicResolver topicResolver = new DefaultTopicResolver();
        List<PulsarProperties.Defaults.TypeMapping> typeMappings = this.properties.getDefaults().getTypeMappings();
        if (typeMappings != null) {
            typeMappings.forEach(typeMapping -> this.addCustomTopicMapping(topicResolver, (PulsarProperties.Defaults.TypeMapping)typeMapping));
        }
        return topicResolver;
    }

    private void addCustomTopicMapping(DefaultTopicResolver topicResolver, PulsarProperties.Defaults.TypeMapping typeMapping) {
        String topicName = typeMapping.topicName();
        if (topicName != null) {
            topicResolver.addCustomTopicMapping(typeMapping.messageType(), topicName);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.pulsar.function.enabled"}, matchIfMissing=true)
    PulsarFunctionAdministration pulsarFunctionAdministration(PulsarAdministration pulsarAdministration, ObjectProvider<PulsarFunction> pulsarFunctions, ObjectProvider<PulsarSink> pulsarSinks, ObjectProvider<PulsarSource> pulsarSources) {
        PulsarProperties.Function properties = this.properties.getFunction();
        return new PulsarFunctionAdministration(pulsarAdministration, pulsarFunctions, pulsarSinks, pulsarSources, properties.isFailFast(), properties.isPropagateFailures(), properties.isPropagateStopFailures());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.pulsar.defaults.topic.enabled"}, matchIfMissing=true)
    PulsarTopicBuilder pulsarTopicBuilder() {
        return new PulsarTopicBuilder(TopicDomain.persistent, this.properties.getDefaults().getTopic().getTenant(), this.properties.getDefaults().getTopic().getNamespace());
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarContainerFactoryCustomizers pulsarContainerFactoryCustomizers(ObjectProvider<PulsarContainerFactoryCustomizer<?>> customizers) {
        return new PulsarContainerFactoryCustomizers(customizers.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarProducerFactory.class})
    @ConditionalOnBooleanProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue=false)
    DefaultPulsarProducerFactory<?> pulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver, ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider, ObjectProvider<PulsarTopicBuilder> topicBuilderProvider) {
        List<ProducerBuilderCustomizer<Object>> lambdaSafeCustomizers = this.lambdaSafeProducerBuilderCustomizers(customizersProvider);
        DefaultPulsarProducerFactory producerFactory = new DefaultPulsarProducerFactory(pulsarClient, this.properties.getProducer().getTopicName(), lambdaSafeCustomizers, topicResolver);
        topicBuilderProvider.ifAvailable(arg_0 -> ((DefaultPulsarProducerFactory)producerFactory).setTopicBuilder(arg_0));
        return producerFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarProducerFactory.class})
    @ConditionalOnBooleanProperty(name={"spring.pulsar.producer.cache.enabled"}, matchIfMissing=true)
    CachingPulsarProducerFactory<?> cachingPulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver, ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider, ObjectProvider<PulsarTopicBuilder> topicBuilderProvider) {
        PulsarProperties.Producer.Cache cacheProperties = this.properties.getProducer().getCache();
        List<ProducerBuilderCustomizer<Object>> lambdaSafeCustomizers = this.lambdaSafeProducerBuilderCustomizers(customizersProvider);
        CachingPulsarProducerFactory producerFactory = new CachingPulsarProducerFactory(pulsarClient, this.properties.getProducer().getTopicName(), lambdaSafeCustomizers, topicResolver, cacheProperties.getExpireAfterAccess(), Long.valueOf(cacheProperties.getMaximumSize()), Integer.valueOf(cacheProperties.getInitialCapacity()));
        topicBuilderProvider.ifAvailable(arg_0 -> ((CachingPulsarProducerFactory)producerFactory).setTopicBuilder(arg_0));
        return producerFactory;
    }

    private List<ProducerBuilderCustomizer<Object>> lambdaSafeProducerBuilderCustomizers(ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeProducerBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        return List.of(builder -> this.applyProducerBuilderCustomizers(customizers, builder));
    }

    private void applyProducerBuilderCustomizers(List<ProducerBuilderCustomizer<?>> customizers, ProducerBuilder<?> builder) {
        LambdaSafe.callbacks(ProducerBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarTemplate<?> pulsarTemplate(PulsarProducerFactory<?> pulsarProducerFactory, ObjectProvider<ProducerInterceptor> producerInterceptors, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        PulsarTemplate template = new PulsarTemplate(pulsarProducerFactory, producerInterceptors.orderedStream().toList(), schemaResolver, topicResolver, this.properties.getTemplate().isObservationsEnabled());
        this.propertiesMapper.customizeTemplate(template);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarConsumerFactory.class})
    DefaultPulsarConsumerFactory<?> pulsarConsumerFactory(PulsarClient pulsarClient, ObjectProvider<ConsumerBuilderCustomizer<?>> customizersProvider, ObjectProvider<PulsarTopicBuilder> topicBuilderProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeConsumerBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ConsumerBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyConsumerBuilderCustomizers(customizers, builder));
        DefaultPulsarConsumerFactory consumerFactory = new DefaultPulsarConsumerFactory(pulsarClient, lambdaSafeCustomizers);
        topicBuilderProvider.ifAvailable(arg_0 -> ((DefaultPulsarConsumerFactory)consumerFactory).setTopicBuilder(arg_0));
        return consumerFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarAwareTransactionManager.class})
    @ConditionalOnBooleanProperty(value={"spring.pulsar.transaction.enabled"})
    PulsarTransactionManager pulsarTransactionManager(PulsarClient pulsarClient) {
        return new PulsarTransactionManager(pulsarClient);
    }

    private void applyConsumerBuilderCustomizers(List<ConsumerBuilderCustomizer<?>> customizers, ConsumerBuilder<?> builder) {
        LambdaSafe.callbacks(ConsumerBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarListenerContainerFactory"})
    ConcurrentPulsarListenerContainerFactory<?> pulsarListenerContainerFactory(PulsarConsumerFactory<Object> pulsarConsumerFactory, SchemaResolver schemaResolver, TopicResolver topicResolver, ObjectProvider<PulsarAwareTransactionManager> pulsarTransactionManager, Environment environment, PulsarContainerFactoryCustomizers containerFactoryCustomizers) {
        PulsarContainerProperties containerProperties = new PulsarContainerProperties(new String[0]);
        containerProperties.setSchemaResolver(schemaResolver);
        containerProperties.setTopicResolver(topicResolver);
        if (Threading.VIRTUAL.isActive(environment)) {
            containerProperties.setConsumerTaskExecutor((AsyncTaskExecutor)new VirtualThreadTaskExecutor("pulsar-consumer-"));
        }
        pulsarTransactionManager.ifUnique(arg_0 -> ((PulsarContainerProperties.TransactionSettings)containerProperties.transactions()).setTransactionManager(arg_0));
        this.propertiesMapper.customizeContainerProperties(containerProperties);
        ConcurrentPulsarListenerContainerFactory containerFactory = new ConcurrentPulsarListenerContainerFactory(pulsarConsumerFactory, containerProperties);
        containerFactoryCustomizers.customize(containerFactory);
        return containerFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarReaderFactory.class})
    DefaultPulsarReaderFactory<?> pulsarReaderFactory(PulsarClient pulsarClient, ObjectProvider<ReaderBuilderCustomizer<?>> customizersProvider, ObjectProvider<PulsarTopicBuilder> topicBuilderProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeReaderBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ReaderBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyReaderBuilderCustomizers(customizers, builder));
        DefaultPulsarReaderFactory readerFactory = new DefaultPulsarReaderFactory(pulsarClient, lambdaSafeCustomizers);
        topicBuilderProvider.ifAvailable(arg_0 -> ((DefaultPulsarReaderFactory)readerFactory).setTopicBuilder(arg_0));
        return readerFactory;
    }

    private void applyReaderBuilderCustomizers(List<ReaderBuilderCustomizer<?>> customizers, ReaderBuilder<?> builder) {
        LambdaSafe.callbacks(ReaderBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarReaderContainerFactory"})
    DefaultPulsarReaderContainerFactory<?> pulsarReaderContainerFactory(PulsarReaderFactory<?> pulsarReaderFactory, SchemaResolver schemaResolver, Environment environment, PulsarContainerFactoryCustomizers containerFactoryCustomizers) {
        PulsarReaderContainerProperties readerContainerProperties = new PulsarReaderContainerProperties();
        readerContainerProperties.setSchemaResolver(schemaResolver);
        if (Threading.VIRTUAL.isActive(environment)) {
            readerContainerProperties.setReaderTaskExecutor((AsyncTaskExecutor)new VirtualThreadTaskExecutor("pulsar-reader-"));
        }
        this.propertiesMapper.customizeReaderContainerProperties(readerContainerProperties);
        DefaultPulsarReaderContainerFactory containerFactory = new DefaultPulsarReaderContainerFactory(pulsarReaderFactory, readerContainerProperties);
        containerFactoryCustomizers.customize(containerFactory);
        return containerFactory;
    }

    @Configuration(proxyBeanMethods=false)
    @EnablePulsar
    @ConditionalOnMissingBean(name={"org.springframework.pulsar.config.internalPulsarListenerAnnotationProcessor", "org.springframework.pulsar.config.internalPulsarReaderAnnotationProcessor"})
    static class EnablePulsarConfiguration {
        EnablePulsarConfiguration() {
        }
    }
}

