/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.autoconfigure.health;

import org.neo4j.driver.Driver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.neo4j.health.Neo4jHealthIndicator;
import org.springframework.boot.neo4j.health.Neo4jReactiveHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

class Neo4jHealthContributorConfigurations {
    Neo4jHealthContributorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Flux.class, Neo4jReactiveHealthIndicator.class})
    static class Neo4jReactiveConfiguration
    extends CompositeReactiveHealthContributorConfiguration<Neo4jReactiveHealthIndicator, Driver> {
        Neo4jReactiveConfiguration() {
            super(Neo4jReactiveHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthIndicator", "neo4jHealthContributor"})
        ReactiveHealthContributor neo4jHealthContributor(ConfigurableListableBeanFactory beanFactory) {
            return (ReactiveHealthContributor)this.createContributor(beanFactory, Driver.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Neo4jHealthIndicator.class})
    static class Neo4jConfiguration
    extends CompositeHealthContributorConfiguration<Neo4jHealthIndicator, Driver> {
        Neo4jConfiguration() {
            super(Neo4jHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthIndicator", "neo4jHealthContributor"})
        HealthContributor neo4jHealthContributor(ConfigurableListableBeanFactory beanFactory) {
            return (HealthContributor)this.createContributor(beanFactory, Driver.class);
        }
    }
}

