/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.autoconfigure;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.neo4j")
public class Neo4jProperties {
    private @Nullable URI uri;
    private Duration connectionTimeout = Duration.ofSeconds(30L);
    private Duration maxTransactionRetryTime = Duration.ofSeconds(30L);
    private final Authentication authentication = new Authentication();
    private final Pool pool = new Pool();
    private final Security security = new Security();

    public @Nullable URI getUri() {
        return this.uri;
    }

    public void setUri(@Nullable URI uri) {
        this.uri = uri;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getMaxTransactionRetryTime() {
        return this.maxTransactionRetryTime;
    }

    public void setMaxTransactionRetryTime(Duration maxTransactionRetryTime) {
        this.maxTransactionRetryTime = maxTransactionRetryTime;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Security getSecurity() {
        return this.security;
    }

    public static class Authentication {
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String realm;
        private @Nullable String kerberosTicket;

        public @Nullable String getUsername() {
            return this.username;
        }

        public void setUsername(@Nullable String username) {
            this.username = username;
        }

        public @Nullable String getPassword() {
            return this.password;
        }

        public void setPassword(@Nullable String password) {
            this.password = password;
        }

        public @Nullable String getRealm() {
            return this.realm;
        }

        public void setRealm(@Nullable String realm) {
            this.realm = realm;
        }

        public @Nullable String getKerberosTicket() {
            return this.kerberosTicket;
        }

        public void setKerberosTicket(@Nullable String kerberosTicket) {
            this.kerberosTicket = kerberosTicket;
        }
    }

    public static class Pool {
        private boolean logLeakedSessions;
        private int maxConnectionPoolSize = 100;
        private @Nullable Duration idleTimeBeforeConnectionTest;
        private Duration maxConnectionLifetime = Duration.ofHours(1L);
        private Duration connectionAcquisitionTimeout = Duration.ofSeconds(60L);

        public boolean isLogLeakedSessions() {
            return this.logLeakedSessions;
        }

        public void setLogLeakedSessions(boolean logLeakedSessions) {
            this.logLeakedSessions = logLeakedSessions;
        }

        public int getMaxConnectionPoolSize() {
            return this.maxConnectionPoolSize;
        }

        public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
            this.maxConnectionPoolSize = maxConnectionPoolSize;
        }

        public @Nullable Duration getIdleTimeBeforeConnectionTest() {
            return this.idleTimeBeforeConnectionTest;
        }

        public void setIdleTimeBeforeConnectionTest(@Nullable Duration idleTimeBeforeConnectionTest) {
            this.idleTimeBeforeConnectionTest = idleTimeBeforeConnectionTest;
        }

        public Duration getMaxConnectionLifetime() {
            return this.maxConnectionLifetime;
        }

        public void setMaxConnectionLifetime(Duration maxConnectionLifetime) {
            this.maxConnectionLifetime = maxConnectionLifetime;
        }

        public Duration getConnectionAcquisitionTimeout() {
            return this.connectionAcquisitionTimeout;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout = connectionAcquisitionTimeout;
        }
    }

    public static class Security {
        private boolean encrypted;
        private TrustStrategy trustStrategy = TrustStrategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;
        private @Nullable File certFile;
        private boolean hostnameVerificationEnabled = true;

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        public TrustStrategy getTrustStrategy() {
            return this.trustStrategy;
        }

        public void setTrustStrategy(TrustStrategy trustStrategy) {
            this.trustStrategy = trustStrategy;
        }

        public @Nullable File getCertFile() {
            return this.certFile;
        }

        public void setCertFile(@Nullable File certFile) {
            this.certFile = certFile;
        }

        public boolean isHostnameVerificationEnabled() {
            return this.hostnameVerificationEnabled;
        }

        public void setHostnameVerificationEnabled(boolean hostnameVerificationEnabled) {
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        }

        public static enum TrustStrategy {
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }
}

